ORCA/M Asm65816 2.1.0

0001 375B                       title 'SANE         Elems         GS ROM 2.0' 
0002 375B              ****************************************************************
0003 375B              *                                                              *
0004 375B              *                      SANE Elems                              *
0005 375B              *                                                              *
0006 375B              ****************************************************************
0007 375B
0008 375B
0009 375B              ****************************************************************
0010 375B              *                                                              *
0011 375B              *                   Copyright (C) 1985-1987                    *
0012 375B              *                   All Rights Reserved                        *
0013 375B              *                   Apple Computer, Inc.                       *
0014 375B              *                                                              *
0015 375B              ****************************************************************
0016 375B
0017 375B              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0018 375B              ;; File:  Elems/Main                                                    ;
0019 375B              ;; Driver file for building 65816 Elems V0.0                            ;
0020 375B              ;; Status: First attempt                                                ;
0021 375B              ;; Copyright Apple Computer, Inc., 1983-1986                            ;
0022 375B              ;; All Rights Reserved                                                  ;
0023 375B              ;;                                                                      ;
0024 375B              ;; Written by C. Hausmann, 1983                                         ;
0025 375B              ;;                                                                      ;
0026 375B              ;; Modification History                                                 ;
0027 375B              ;;      21Mar86 CRL     Revised for 65816                               ;
0028 375B              ;;                                                                      ;
0029 375B              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0030 375B
0031 375B                       include 'elems.macros' 
0032 375B                       include '::sys.equs.asm' 
0033 375B              ;------------------------------------------
0034 375B              ;
0035 375B              ; Equates from procedure CLASS_NAN
0036 375B              ;
0037 375B              ;------------------------------------------
0038 375B              FCINF    EQU   $FE                      ; -2: infinite
0039 375B              FCZERO   EQU   $FF                      ; -1: zero
0040 375B              FCNORM   EQU   $00                      ;  0: normal
0041 375B              FCDENORM EQU   $01                      ;  1: denormal
0042 375B              NANTRIG  EQU   33                       ; Invalid argument to trig routine. 
0043 375B              NANLOG   EQU   36                       ; Invalid argument to log routine. 
0044 375B              NANPOWER EQU   37                       ; Invalid argument to x^i or x^y routine. 
0045 375B              NANFINAN EQU   38                       ; Invalid argument to financial function. 
0046 375B              FOLOG2X  EQU   2
0047 375B              FOLOG21X EQU   6
0048 375B              FOEXP2X  EQU   $A
0049 375B              FOEXP1X  EQU   $C
0050 375B              FOEXP21X EQU   $E
0051 375B
0052 375B
0053 375B              ;=================================================
0054 375B              ;
0055 375B              ; Imports
0056 375B              ;
0057 375B                       IMPORT Clayton 
0058 375B
0059 375B
0060 375B              ;-----------------------------------------------
0061 375B              ;
0062 375B              ;   Forward addresses and entries
0063 375B              ;
0064 375B              ;-----------------------------------------------
0065 375B
0066 375B                       ENTRY ANN01
0067 375B                       ENTRY ANN02
0068 375B                       ENTRY ANNALLLOG
0069 375B                       ENTRY ANNDOIT
0070 375B                       ENTRY ANNDOUT
0071 375B                       ENTRY ANNM1
0072 375B                       ENTRY ANNO
0073 375B                       ENTRY ANNOK
0074 375B                       ENTRY ANNRINF
0075 375B                       ENTRY ANNROK
0076 375B                       ENTRY ANNSRC
0077 375B                       ENTRY ANNUITYTOP
0078 375B                       ENTRY ANNXN
0079 375B                       ENTRY ATANP
0080 375B                       ENTRY ATANQ
0081 375B                       ENTRY ATANTOP
0082 375B                       ENTRY CALL_SANE
0083 375B                       ENTRY CHECKOP
0084 375B                       ENTRY CLASSIFY
0085 375B                       ENTRY CLASSSRC2
0086 375B                       ENTRY CMPGTM1
0087 375B                       ENTRY CMPM1N
0088 375B                       ENTRY CMPTOFIN
0089 375B                       ENTRY CMPZERO
0090 375B                       ENTRY COEFFS
0091 375B                       ENTRY COMPOUNDTOP
0092 375B                       ENTRY COSP
0093 375B                       ENTRY COSQ
0094 375B                       ENTRY COSTOP
0095 375B                       ENTRY DOPROCENTRY
0096 375B                       ENTRY DOSCALE
0097 375B                       ENTRY DSTONLY
0098 375B                       ENTRY ERRFINAN
0099 375B                       ENTRY EXAPPROX
0100 375B                       ENTRY EXP1FINITE
0101 375B                       ENTRY EXP1R
0102 375B                       ENTRY EXP1RDONE
0103 375B                       ENTRY EXP1ROOT
0104 375B                       ENTRY EXP1TOP
0105 375B                       ENTRY EXP21P
0106 375B                       ENTRY EXP21Q
0107 375B                       ENTRY EXP21RNORM
0108 375B                       ENTRY EXPEASY
0109 375B                       ENTRY EXPHARD
0110 375B                       ENTRY EXPNONZERO
0111 375B                       ENTRY EXPR
0112 375B                       ENTRY EXPROOT
0113 375B                       ENTRY EXPTOP
0114 375B                       ENTRY FINPWRI
0115 375B                       ENTRY FINPWRY
0116 375B                       ENTRY FPK0
0117 375B                       ENTRY FPK1
0118 375B                       ENTRY FPK2
0119 375B                       ENTRY FPK3
0120 375B                       ENTRY FPK34
0121 375B                       ENTRY FPK78
0122 375B                       ENTRY FPKARAND
0123 375B                       ENTRY FPKATNCONS
0124 375B                       ENTRY FPKE
0125 375B                       ENTRY FPKFOURTH
0126 375B                       ENTRY FPKHALF
0127 375B                       ENTRY FPKINF
0128 375B                       ENTRY FPKLOGE2
0129 375B                       ENTRY FPKM0
0130 375B                       ENTRY FPKM1
0131 375B                       ENTRY FPKMAXINT
0132 375B                       ENTRY FPKMINF
0133 375B                       ENTRY FPKPI2
0134 375B                       ENTRY FPKPI4
0135 375B                       ENTRY FPKPRAND
0136 375B                       ENTRY FPKSQRT2
0137 375B                       ENTRY FPKSQRTHALF
0138 375B                       ENTRY FPKX2
0139 375B                       ENTRY FPKX2FX2
0140 375B                       ENTRY F_MAXINT
0141 375B                       ENTRY KLUGE10
0142 375B                       ENTRY KLUGE12
0143 375B                       ENTRY KLUGE13
0144 375B                       ENTRY KLUGE17
0145 375B                       ENTRY KLUGE2
0146 375B                       ENTRY KLUGE3
0147 375B                       ENTRY KLUGE36
0148 375B                       ENTRY KLUGE4
0149 375B                       ENTRY KLUGE40
0150 375B                       ENTRY KLUGE42
0151 375B                       ENTRY KLUGE44
0152 375B                       ENTRY KLUGE6
0153 375B                       ENTRY KLUGE61
0154 375B                       ENTRY KLUGE62
0155 375B                       ENTRY KLUGE63
0156 375B                       ENTRY KLUGE64
0157 375B                       ENTRY KLUGE67
0158 375B                       ENTRY KLUGE68
0159 375B                       ENTRY KLUGE7
0160 375B                       ENTRY KLUGE8
0161 375B                       ENTRY KLUGE90
0162 375B                       ENTRY KLUGE91
0163 375B                       ENTRY KLUGE92
0164 375B                       ENTRY KLUGE93
0165 375B                       ENTRY KLUGE97
0166 375B                       ENTRY LAFINI
0167 375B                       ENTRY LANONZERO
0168 375B                       ENTRY LANORMAL
0169 375B                       ENTRY LOG12R
0170 375B                       ENTRY LOG1PLUSX
0171 375B                       ENTRY LOG21P
0172 375B                       ENTRY LOG21Q
0173 375B                       ENTRY LOG2R
0174 375B                       ENTRY LOGAPPROX
0175 375B                       ENTRY LOGERROR
0176 375B                       ENTRY LOGFINI
0177 375B                       ENTRY LOGINFIN
0178 375B                       ENTRY LOGO
0179 375B                       ENTRY LOGTOP
0180 375B                       ENTRY MAKESRC2
0181 375B                       ENTRY NEGPWRY
0182 375B                       ENTRY NONPWRY
0183 375B                       ENTRY OPERAND
0184 375B                       ENTRY POLYEVAL
0185 375B                       ENTRY POVERQ
0186 375B                       ENTRY PastPrivate
0187 375B                       ENTRY RANDTOP
0188 375B                       ENTRY RESULTDELIVERED
0189 375B                       ENTRY SINP
0190 375B                       ENTRY SINQ
0191 375B                       ENTRY SINTOP
0192 375B                       ENTRY SPLIT
0193 375B                       ENTRY SPLIT2
0194 375B                       ENTRY TANP
0195 375B                       ENTRY TANQ
0196 375B                       ENTRY TANTOP
0197 375B                       ENTRY TRIGFINI
0198 375B                       ENTRY TRIGREDUCTION
0199 375B                       ENTRY VSMAXINT
0200 375B                       ENTRY XKLPENTRY
0201 375B                       ENTRY XKLPSKIP
0202 375B                       ENTRY XPWRBIG
0203 375B                       ENTRY XPWRITOP
0204 375B                       ENTRY XPWRK
0205 375B                       ENTRY XPWRKCLEAR
0206 375B                       ENTRY XPWRKDIV
0207 375B                       ENTRY XPWRKLOOP
0208 375B                       ENTRY XPWRY
0209 375B                       ENTRY XPWRYCOM
0210 375B                       ENTRY XPWRYHARD
0211 375B                       ENTRY XPWRYOK
0212 375B                       ENTRY XPWRYTOP
0213 375B                       ENTRY Z0S00
0214 375B                       ENTRY ZPWRNEG
0215 375B
0216 375B
0217 375B                       ENTRY Call_FP
0218 375B                       ENTRY Call_El
0219 375B
0220 375B
0221 375B              ;                copy elems/equs.o
0222 375B              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0223 375B              ;; File:  equS.o
0224 375B              ;; Global equs for building 65816 Elems V0.0
0225 375B              ;; Status: First attempt
0226 375B              ;; Copyright Apple Computer, Inc., 1983-1986
0227 375B              ;; All Rights Reserved
0228 375B              ;;
0229 375B              ;; Written by C. Lewis, May 1986
0230 375B              ;;
0231 375B              ;; Modification History
0232 375B              ;;       12May86 CRL Update Zero Page Use to agree with FP816 changes.
0233 375B              ;;
0234 375B              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0235 375B              ;
0236 375B              ; NOTE HARD REFERENCES TO FP816 EQUS.
0237 375B              ;
0238 375B              OrigDirect equ   6                      ; from FP's equ table
0239 375B              OrigBank equ   8                        ; from FP's equ table
0240 375B              Space1   equ   98                       ; 16 bytes at FP's FrctA+10
0241 375B              Space2   equ   124                      ; 16 bytes at FP's FrctB+10
0242 375B              Space3   equ   150                      ; 96 bytes at FP's FrctC+10
0243 375B              ;
0244 375B              FFMask   equ   $FF
0245 375B              ;
0246 375B              ;
0247 375B              ; Equates used for setting up calls to the Engine.  See routine CALL_SANE
0248 375B              ; below.  NOTE: Portions of the code expect entries other than F_DEST to
0249 375B              ; be nonzero so branches work correctly.
0250 375B              ;
0251 375B              F_DEST   equ   0
0252 375B              F_SRC    equ   2
0253 375B              F_SRC2   equ   4
0254 375B              F_ISRC   equ   6
0255 375B              F_I      equ   8
0256 375B              F_J      equ   10
0257 375B              F_W      equ   12
0258 375B              F_X      equ   14
0259 375B              F_Y      equ   16
0260 375B              F_Z      equ   18
0261 375B              F_LOG21P equ   20
0262 375B              F_LOG21Q equ   22
0263 375B              F_EXP21P equ   24
0264 375B              F_EXP21Q equ   26
0265 375B              F_FPK1   equ   28
0266 375B              F_FPKM1  equ   30
0267 375B              F_FPK2   equ   32
0268 375B              F_FPK3   equ   34
0269 375B              F_FPKMAXINT equ   36
0270 375B              F_FPKSQRT2 equ   38
0271 375B              F_FPKHALF equ   40
0272 375B              F_FPKSQTHALF equ   42
0273 375B              F_FPKFOURTH equ   44
0274 375B              F_FPK34  equ   46
0275 375B              F_FPK78  equ   48
0276 375B              F_FPKPI2 equ   50
0277 375B              F_FPKPI4 equ   52
0278 375B              F_FPKE   equ   54
0279 375B              F_FPKLOGE2 equ   56
0280 375B              F_FPK0   equ   58
0281 375B              F_FPKM0  equ   60
0282 375B              F_FPKINF equ   62
0283 375B              F_FPKMINF equ   64
0284 375B              F_SINQ   equ   66
0285 375B              F_SINP   equ   68
0286 375B              F_COSQ   equ   70
0287 375B              F_COSP   equ   72
0288 375B              F_TANQ   equ   74
0289 375B              F_TANP   equ   76
0290 375B              F_ATANQ  equ   78
0291 375B              F_ATANP  equ   80
0292 375B              F_FPKX2  equ   82
0293 375B              F_FPKX2FX2 equ   84
0294 375B              F_FPKATNCONS equ   86
0295 375B              F_FPKARAND equ   88
0296 375B              F_FPKPRAND equ   90
0297 375B              F_EXCPTION equ   92
0298 375B              F_OLDENV equ   94
0299 375B              F_SAVE_ENV equ   96
0300 375B              F_ACCUM  equ   98                       ; Corresponds to V_TEMP
0301 375B              ;
0302 375B              ;
0303 375B              ; There are four logarithm functions:  LN(x), LOG2(x), LN(1+x), and LOG2(1+x).
0304 375B              ; They share much of the same code, but are distinguished by two bits.
0305 375B              ; In the same way, EXP(x), EXP2(x), EXP(x)-1, EXP2(x)-1 share the same
0306 375B              ; startup code.
0307 375B              ;
0308 375B              BTLOGBASE2 equ   1                      ; Set if either LOG2(x) or LOG2(1+x)
0309 375B              ;                                       ; Set if either EXP2(x) or EXP2(x)-1
0310 375B              BTLOG1PLUSX equ   2                     ; Set if either LN (1+x) or LOG2(1+x)
0311 375B              ;                                       ; Set if either EXP(x)-1 or EXP2(x)-1
0312 375B              EXT_LEN  equ   9                        ; Length in bytes of extended value
0313 375B              EXT_SIZE equ   10                       ; Size in bytes of extended value.
0314 375B              ;
0315 375B              OP1ADRS  equ   $00
0316 375B              OP2ADRS  equ   $80
0317 375B              OP3ADRS  equ   $C0
0318 375B              ;
0319 375B              OPXPWRI  equ   $08                      ; <0000 1000> - after ROR
0320 375B              ;
0321 375B              ; Storage for temporaries. DIRECT PAGE OFFSETS.
0322 375B              ;
0323 375B              ;
0324 375B              OPCODE   equ   Space1                   ; Index into jump table
0325 375B              NUM_ADDR equ   Space1+1
0326 375B              ;
0327 375B              EXCPTION equ   Space1+2                 ; Exception (-4..1)
0328 375B              ;
0329 375B              OLD_ENV  equ   Space1+4
0330 375B              SAVE_ENV equ   Space1+6                 ; Ptr to saved user's environ
0331 375B              ;
0332 375B              SRC_CLASS equ   Space1+8                ; Source class
0333 375B              SRC_SIGN equ   Space1+9
0334 375B              SRC2_CLASS equ   Space1+$A
0335 375B              SRC2_SIGN equ   Space1+$B
0336 375B              CLASS_CODE equ   Space1+$C
0337 375B              CLASS_SIGN equ   Space1+$D
0338 375B              I_SRC    equ   Space1+$E
0339 375B              ;                                       0 bytes free at end of Space1
0340 375B              OP0_ADDR equ   Space2
0341 375B              OP1_ADDR equ   Space2+3
0342 375B              ;
0343 375B              ; Data area for extended parameters
0344 375B              ;
0345 375B              DEST     equ   Space2+6
0346 375B              ;                                       0 bytes free at end of Space2
0347 375B              SRC      equ   Space3
0348 375B              SRC2     equ   SRC+$A
0349 375B              ;
0350 375B              ; Used to save zero page addresses for destination and source.  This is
0351 375B              ; necessary because these locations are not guaranteed across calls to
0352 375B              ; the SANE engine.  [UNCHANGED FOR 816 CODE.   CRL]
0353 375B              ;
0354 375B              SAVE_DEST equ   SRC2+$A
0355 375B              SAVE_SRC2 equ   SAVE_DEST+3
0356 375B              SAVE1_CLASS equ   SAVE_SRC2+3
0357 375B              SAVE1_SIGN equ   SAVE1_CLASS+1
0358 375B              SAVE2_CLASS equ   SAVE1_SIGN+1
0359 375B              SAVE2_SIGN equ   SAVE2_CLASS+1
0360 375B              ;
0361 375B              ; Extended and integer temporaries
0362 375B              ;
0363 375B              V_TEMP   equ   SAVE2_SIGN+1             ; V - only used to save extended
0364 375B              ;                                       ;   value prior to recursion
0365 375B              FPTRASH  equ   V_TEMP+$A                ; trashed by calls to FP
0366 375B              I_TEMP   equ   FPTRASH+5
0367 375B              J_TEMP   equ   I_TEMP+2
0368 375B              W_TEMP   equ   J_TEMP+2                 ; W
0369 375B              X_TEMP   equ   W_TEMP+$A                ; X
0370 375B              Y_TEMP   equ   X_TEMP+$A                ; Y
0371 375B              Z_TEMP   equ   Y_TEMP+$A                ; Z
0372 375B              ;
0373 375B              ; Temporary variables - most often used to pass addresses to various
0374 375B              ; routines.  A0_ADDR is also used in the front end and again at
0375 375B              ; resultdelivered to hold temporarily the 6 bytes of return address
0376 375B              ; from the original stack.
0377 375B              ;
0378 375B              A0_ADDR  equ   Z_TEMP+$A                ; 3 bytes
0379 375B              D0_TEMP  equ   A0_ADDR+3                ; 2 bytes
0380 375B              D2_TEMP  equ   D0_TEMP+2                ; 2 bytes
0381 375B              ;                                       0 bytes free at end of Space3
0382 375B
0383 375B
0384 375B
0385 375B
0386 375B
0387 375B              ;                  COPY           elems/EQUS.O           ; Elem equates
0388 375B              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0389 375B              ;; File:  EQUS.o
0390 375B              ;; EQUs for building 65816 Elems V0.0
0391 375B              ;; Status: First attempt
0392 375B              ;; Copyright Apple Computer, Inc., 1983-1986
0393 375B              ;; All Rights Reserved
0394 375B              ;;
0395 375B              ;; Written by C. Hausmann, 1983
0396 375B              ;;
0397 375B              ;; Modification History
0398 375B              ;;      21Mar86 CRL     Revised for 65816
0399 375B              ;;
0400 375B              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0401 375B              ;
0402 375B              FBINVALID EQU   1
0403 375B              FBUFLOW  EQU   2
0404 375B              FBOFLOW  EQU   4
0405 375B              FBDIVZER EQU   8
0406 375B              FBINEXACT EQU   $10
0407 375B              FBIplusX EQU   $11
0408 375B              ;
0409 375B              ;-----------------------------------------------------------
0410 375B              ; Operation code masks.
0411 375B              ;-----------------------------------------------------------
0412 375B              FOADD    EQU   $00                      ; add
0413 375B              FOSUB    EQU   $02                      ; subtract
0414 375B              FOMUL    EQU   $04                      ; multiply
0415 375B              FODIV    EQU   $06                      ; divide
0416 375B              FOCMP    EQU   $08                      ; compare, no exception from unordered
0417 375B              FOREM    EQU   $0C                      ; remainder
0418 375B              FOZ2X    EQU   $0E                      ; convert to extended
0419 375B              FOX2Z    EQU   $10                      ; convert from extended
0420 375B              FORTI    EQU   $14                      ; round to integral value
0421 375B              FOSCALB  EQU   $18                      ; binary scale
0422 375B              FOLOGB   EQU   $1A                      ; binary log
0423 375B              FOCLASS  EQU   $1C                      ; classify
0424 375B              ;
0425 375B              FOSETENV EQU   $01                      ; set environment
0426 375B              FOGETENV EQU   $03                      ; get environment
0427 375B              FONEG    EQU   $0D                      ; negate
0428 375B              FOABS    EQU   $0F                      ; absolute value
0429 375B              ; UNDEFINED    EQU	  $13
0430 375B              FOSETXCP EQU   $15                      ; set exception
0431 375B              FOPROCENTRY EQU   $17                   ; procedure-entry
0432 375B              FOPROCEXIT EQU   $19                    ; procedure-exit
0433 375B              FOTESTXCP EQU   $1B                     ; test exception
0434 375B              ; UNDEFINED    EQU	  $1D
0435 375B              ; UNDEFINED    EQU	  $1F
0436 375B              ;
0437 375B              ;-----------------------------------------------------------
0438 375B              ; Operand format masks.
0439 375B              ;-----------------------------------------------------------
0440 375B              FFEXT    EQU   $0                       ; extended -- 80-bit float
0441 375B              FFINT    EQU   $4                       ; integer  -- 16-bit integer
0442 375B              ;
0443 375B              ;
0444 375B              ;-----------------------------------------------------------
0445 375B              ; Class and sign inquiries.
0446 375B              ;-----------------------------------------------------------
0447 375B              ;       
0448 375B              ;-----------------------------------------------------------
0449 375B              ; NaN codes.  
0450 375B              ;-----------------------------------------------------------
0451 375B              ;
0452 375B              ;-----------------------------------------------------------
0453 375B              ; Elementary function operation code masks.
0454 375B              ;-----------------------------------------------------------
0455 375B              ;
0456 375B
0457 375B
0458 375B              ;
0459 375B              ; END OF FILE
0460 375B              ;
0461 375B              ; Popping stack of parameters (start up), general routines such as Polyeval,
0462 375B              ; Negate, Scalbxx, and clean up at end (pushing of result onto stack)
0463 375B              ;                  COPY           elems/ELEMCTRL.O.A
0464 375B              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0465 375B              ;; File:  ElemCTRL.O.A                                                   ;
0466 375B              ;; For building 65816 Elems V0.0                                         ;
0467 375B              ;; Status: First attempt                                                 ;
0468 375B              ;; Copyright Apple Computer, Inc., 1983-1986                             ;
0469 375B              ;; All Rights Reserved                                                   ;
0470 375B              ;;                                                                       ;
0471 375B              ;; Written by C. Hausmann, 1983                                          ;
0472 375B              ;;                                                                       ;
0473 375B              ;; Modification History                                                  ;
0474 375B              ;;   Dec 7 1983 - Revised by C.A.Hausmann                                ;
0475 375B              ;;                Modified order of evaluation in TANGUTS to provide more;
0476 375B              ;;                accurate results.  Calculates X^3*[X^2 * P/Q] instead  ;
0477 375B              ;;                of [X^5] * [P/Q].                                      ;
0478 375B              ;;                Changed TAN such that TAN(+PI/2) = +INF and            ;
0479 375B              ;;                                      TAN(-PI/2) = -INF                ;
0480 375B              ;;   Jan 11 1984 - Modified order of evaluation in SINGUTS to calculate  ;
0481 375B              ;;                 [ X * (X*X)] * [P/Q] instead of X * [(X*X)(P/Q]       ;
0482 375B              ;;                 Fixed table bugs in SINQ and COSQ                     ;
0483 375B              ;;                 Fixed sign bug in TAN                                 ;
0484 375B              ;;                 Fixed operand-trashing bug (if SRC=DEST) in X^Y,      ;
0485 375B              ;;                 compound, and annuity                                 ;
0486 375B              ;;                                                                       ;
0487 375B              ;;   Apr 3 1985  - CRL  Clean up redundant code.                         ;
0488 375B              ;;                      Changes involve writing much of the common code  ;
0489 375B              ;;                      in the form of kluges and then JMP & JSR to them ;
0490 375B              ;;                      1-2        call_sane, call1_sane, calliv_sane    ;
0491 375B              ;;                      3          exp1done                              ;
0492 375B              ;;                      4          xpwryhard                             ;
0493 375B              ;;                      5          xpwry and cmptofin                    ;
0494 375B              ;;                      6          sintop and tantop                     ;
0495 375B              ;;                      8 & 40-51  MOVEIT                                ;
0496 375B              ;;                      10-12      common stuff in PolyLoop              ;
0497 375B              ;;                      13         scalebxx and skipfirstscaleb          ;
0498 375B              ;;                      17         expr and exp1r                        ;
0499 375B              ;;                      19-28 & 90's  calls to call_sane                 ;
0500 375B              ;;                      30 & 31    calls to call_elems & call1v_sane     ;
0501 375B              ;;                      60's       calls to call1_sane                   ;
0502 375B              ;;                                                                       ;
0503 375B              ;;      21Mar86 CRL     Revised for 65816                                ;
0504 375B              ;;                                                                       ;
0505 375B              ;;       8Nov86 KLH     Elems bug fixed in classify                      ;
0506 375B              ;;                                                                       ;
0507 375B              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0508 375B              ;                                                                        ;
0509 375B              ;                             Elementary Functions                       ;
0510 375B              ;                                                                        ;
0511 375B              ;                 Compound Interest and Present Value Functions          ;
0512 375B              ;                                                                        ;
0513 375B              ;                            Trigonometry Functions                      ;
0514 375B              ;                                                                        ;
0515 375B              ;                                                                        ;
0516 375B              ;                             by Carol A. Hausmann                       ;
0517 375B              ;                                                                        ;
0518 375B              ;                                                                        ;
0519 375B              ;              From Pascal code by David Hough and Colin McMaster        ;
0520 375B              ;              (elementary functions and compound interest and           ;
0521 375B              ;              present value functions) and 68000 code by                ;
0522 375B              ;              Jerome Coonen (elementary functions, compound interest    ;
0523 375B              ;              and present value functions, trigonometry functions)      ;
0524 375B              ;              and Pascal code by Kenton Hanson (trigonometry            ;
0525 375B              ;              functions)                                                ;
0526 375B              ;                                                                        ;
0527 375B              ;                     Copyright Apple Computer Inc.,  1984               ;
0528 375B              ;                                                                        ;
0529 375B              ;------------------------------------------------------------------------;
0530 375B              ;
0531 375B              ;
0532 375B              ; When ELEM6502 is entered the stack has the form:
0533 375B              ;     2 ret adrs  <  opcode word  <  dst adrs  <  src adrs  <  scc2 adrs
0534 375B              ; with a second source address only in the case of the financial functions
0535 375B              ; Compound and Annuity.
0536 375B              ;
0537 375B              ; The temporaries which are set up in a stack frame for the MAC version
0538 375B              ; (ELEMS68K) are allocated in the data space for the ELEM6502 version,
0539 375B              ; and in the direct page for the 816 version.
0540 375B              ;
0541 375B              ; The opword is defined as:
0542 375B              ;       0000 0000 NNNN NNN0
0543 375B              ;
0544 375B              ;
0545 375B              ; When raising extended to an integer power, do explicit multiplies when
0546 375B              ; the exponent is smaller than some threshold.  It's 255 for now.
0547 375B              ; When the exponent exceeds this threshold, computation is done with
0548 375B              ; log and exp.  The 6502 version never looks directly for the value, 255.
0549 375B              ; It is only necessary to look at the high byte to see if a number is
0550 375B              ; <= 255.
0551 375B              ;
0552 375B              ;SMALLEXP        .EQU            255
0553 375B              ;
0554 375B              ;
0555 375B              ELEMS816 PROC EXPORT 
0556 375B 22 64 00 E1           JSL   IncBusyFlg
0557 375F              ;
0558 375F 0B                    PHD                            ; save direct register, set up
0559 3760 5B                    TCD                            ;   for use of SANE direct page
0560 3761 68                    PLA   
0561 3762 85 06                 STA   <OrigDirect              ; note: same space as FP uses!!!
0562 3764 8B                    PHB                            ; save original data bank reg'r
0563 3765 8B                    PHB   
0564 3766 68                    PLA   
0565 3767 85 08                 STA   <OrigBank                ; note: same space as FP uses!!!
0566 3769 4B                    PHK                            ; now set data bank register
0567 376A AB                    PLB                            ;   to point to this rom bank
0568 376B 80 04                 BRA   PastPrivate
0569 376D              ;
0570 376D                       EXPORT PrivateEntry 
0571 376D              PrivateEntry                            ;       
0572 376D 22 64 00 E1           JSL   IncBusyFlg
0573 3771                       EXPORT PastPrivate 
0574 3771              PastPrivate                             ; 
0575 3771 68                    PLA   
0576 3772 85 F3                 STA   <A0_ADDR+4               ; pop 6 bytes of return address
0577 3774 68                    PLA   
0578 3775 85 F1                 STA   <A0_ADDR+2
0579 3777 68                    PLA   
0580 3778 85 EF                 STA   <A0_ADDR
0581 377A                       LONGA OFF
0582 377A                       LONGI OFF
0583 377A E2 30                 SEP   #$30
0584 377C 68                    PLA   
0585 377D 85 62                 STA   <OPCODE                  ; Function
0586 377F 68                    PLA   
0587 3780 18                    CLC   
0588 3781 66 62                 ROR   <OPCODE                  ; Set up index into tables
0589 3783              ;                                       ; ELEMSTAB (jump table) and
0590 3783              ;                                       ; ADDR_TAB
0591 3783 A6 62                 LDX   <OPCODE
0592 3785 BD 14 38              LDA   |ADDR_TAB,X
0593 3788 85 63                 STA   <NUM_ADDR                ; Number of addresses to pop
0594 378A              ;
0595 378A              ; Fetch the Destination address - always
0596 378A              ;
0597 378A 68 85 AA 68           POP4 <SAVE_DEST                ; Dst adrs, another adrs coming
0598 3794 DA A0 09 BB  Z0SCE    COPY_EXTEND <SAVE_DEST,<DEST   ; Save copy of extended
0599 37A1 A5 6A                 LDA   <SRC_CLASS               ; Possibly from previous
0600 37A3              ;                                       ; invokation
0601 37A3 85 B0                 STA   <SAVE1_CLASS             ; Will be saved on the stack
0602 37A5              ;                                       ; later - make copy.
0603 37A5 A5 6B                 LDA   <SRC_SIGN
0604 37A7 85 B1                 STA   <SAVE1_SIGN
0605 37A9 A5 6C                 LDA   <SRC2_CLASS
0606 37AB 85 B2                 STA   <SAVE2_CLASS
0607 37AD A5 6D                 LDA   <SRC2_SIGN
0608 37AF 85 B3                 STA   <SAVE2_SIGN
0609 37B1 A5 63                 LDA   <NUM_ADDR
0610 37B3 30 03                 BMI   Z0S00                    ; 2 or 3 addresses
0611 37B5 4C 3C 38              JMP   DSTONLY                  ; Only one address - so don't
0612 37B8              ;                                       ; fetch source
0613 37B8              ;
0614 37B8              ; Fetch the Source address - two,three-address case only
0615 37B8              ;
0616 37B8                       EXPORT Z0S00 
0617 37B8              Z0S00                                   ; ; Copy src using save_src2
0618 37B8 A5 62                 LDA   <OPCODE
0619 37BA C9 08                 CMP   #OPXPWRI
0620 37BC F0 2E                 BEQ   z1s01                    ; Special X^I case
0621 37BE 68 85 AD 68           POP4 <SAVE_SRC2                ; Temp use until z1s01
0622 37C8 DA A0 09 BB  Z0S01    COPY_EXTEND <SAVE_SRC2,<SRC    ; Again, make copy
0623 37D5              ;
0624 37D5              ; Classify the source, but NOT for special XPWRI case
0625 37D5              ;
0626 37D5 A5 AD 85 7C           MOVE3 <SAVE_SRC2,<OP0_ADDR     ; Classify src operand
0627 37E1 20 25 38              JSR   CLASSIFY
0628 37E4 86 6A                 STX   <SRC_CLASS
0629 37E6 29 80                 AND   #$80                     ; show only sign bit
0630 37E8 85 6B                 STA   <SRC_SIGN
0631 37EA 80 06                 BRA   z1s02
0632 37EC              ;
0633 37EC              ; Special copy required for XPWRI case.  In this case, the integer itself
0634 37EC              ; was one the stack.
0635 37EC              ;
0636 37EC                       EXPORT Z1S01 
0637 37EC              Z1S01                                   ; 
0638 37EC 68 85 70 68           POP2 <I_SRC
0639 37F2 A9 C0        Z1S02    LDA   #OP3ADRS                 ; In one or two-address case,
0640 37F4 25 63                 AND   <NUM_ADDR                ; will be pretending there
0641 37F6 49 C0                 EOR   #OP3ADRS                 ; is a src2 by making a copy
0642 37F8 D0 46                 BNE   MAKESRC2                 ; of dest.
0643 37FA              ;
0644 37FA              ; Fetch Source2 address - three-address case only
0645 37FA              ;
0646 37FA 68 85 AD 68           POP4 <SAVE_SRC2
0647 3804 DA A0 09 BB  Z1S03    COPY_EXTEND <SAVE_SRC2,<SRC2
0648 3811 4C 55 38              JMP   CLASSSRC2                ; Classify source2
0649 3814 00           ADDR_TAB DC B:OP1ADRS                   ; LNX
0650 3815 00                    DC B:OP1ADRS                   ; LOG2X
0651 3816 00                    DC B:OP1ADRS                   ; LN1X
0652 3817 00                    DC B:OP1ADRS                   ; LOG21X
0653 3818 00                    DC B:OP1ADRS                   ; EXPX
0654 3819 00                    DC B:OP1ADRS                   ; EXP2X
0655 381A 00                    DC B:OP1ADRS                   ; EXPX  - 1
0656 381B 00                    DC B:OP1ADRS                   ; EXP2X - 1
0657 381C 80                    DC B:OP2ADRS                   ; XPWRI
0658 381D 80                    DC B:OP2ADRS                   ; XPWRY
0659 381E C0                    DC B:OP3ADRS                   ; COMPOUND
0660 381F C0                    DC B:OP3ADRS                   ; ANNUITY
0661 3820 00                    DC B:OP1ADRS                   ; ATANX
0662 3821 00                    DC B:OP1ADRS                   ; SINX
0663 3822 00                    DC B:OP1ADRS                   ; COSX
0664 3823 00                    DC B:OP1ADRS                   ; TANX
0665 3824 00                    DC B:OP1ADRS                   ; RANDOMX
0666 3825                       ENDP 
0667 3825              ;
0668 3825              ; Routine to classify the operands - A0_addr pts to the extended value.
0669 3825              ; The class code is returned in X, the sign is returned in Y.
0670 3825              ;
0671 3825                       EXPORT CLASSIFY 
0672 3825              CLASSIFY PROC 
0673 3825                       LONGA ON
0674 3825                       LONGI ON
0675 3825 C2 30                 REP   #$30
0676 3827 A6 7C                 LDX   <OP0_ADDR
0677 3829 0B                    phd                            ;<3Nov86 klh>
0678 382A 8B                    phb                            ;<3Nov86 klh>
0679 382B A5 7E                 LDA   <OP0_ADDR+2              ;<3Nov86 klh>
0680 382D 48                    pha                            ;<3Nov86 klh>
0681 382E 80 05                 bra   elemfix                  ;<3Nov86 klh>
0682 3830              ;
0683 3830                       EXPORT CLASS_2 
0684 3830              CLASS_2                                 ;       
0685 3830 0B                    PHD                            ; save settings of D and B
0686 3831 8B                    PHB   
0687 3832 F4 00 00              PEA   0                        ; push addr in X
0688 3835 DA           elemfix  PHX                            ;<3Nov86 klh>
0689 3836 A9 1C 00              LDA   #FOCLASS                 ; invoke class fcn in engine
0690 3839 4C 38 39              JMP   KLUGE2
0691 383C                       LONGA OFF
0692 383C                       LONGI OFF
0693 383C              ;
0694 383C                       EXPORT DSTONLY 
0695 383C              DSTONLY                                 ;       
0696 383C A9 00                 LDA   #FCNORM                  ; Even though no source exists
0697 383E              ;                                       ; for this case, fake a non-NAN
0698 383E              ;                                       ; Class code for easy handling
0699 383E              ;                                       ; of NAN checks
0700 383E 85 6A                 STA   <SRC_CLASS
0701 3840              ;
0702 3840              ; Pretend there is a Source2 address - one-two address case
0703 3840              ;
0704 3840                       EXPORT MAKESRC2 
0705 3840              MAKESRC2                                ;       
0706 3840 A2 0A                 LDX   #EXT_SIZE
0707 3842 B5 81        Z2S99    LDA   <DEST-1,X
0708 3844 95 9F                 STA   <SRC2-1,X
0709 3846 CA                    DEX   
0710 3847 D0 F9                 BNE   z2s99
0711 3849 A5 AA 85 AD           MOVE3 <SAVE_DEST,<SAVE_SRC2
0712 3855              ;
0713 3855              ; Whether we faked source2 or popped it off the stack, classify it!
0714 3855              ;
0715 3855                       EXPORT CLASSSRC2 
0716 3855              CLASSSRC2                               ;       
0717 3855 A5 AD 85 7C           MOVE3 <SAVE_SRC2,<OP0_ADDR
0718 3861 20 25 38              JSR   CLASSIFY
0719 3864 86 6C                 STX   <SRC2_CLASS
0720 3866 29 80                 AND   #$80                     ; show only sign bit
0721 3868 85 6D                 STA   <SRC2_SIGN               ;   and save
0722 386A                       LONGA ON
0723 386A                       LONGI ON
0724 386A C2 30                 REP   #$30
0725 386C A5 EF                 LDA   <A0_ADDR                 ; put both return addresses
0726 386E 48                    PHA                            ;   back on the stack
0727 386F A5 F1                 LDA   <A0_ADDR+2
0728 3871 48                    PHA   
0729 3872 A5 F3                 LDA   <A0_ADDR+4
0730 3874 48                    PHA   
0731 3875 20 B8 38              JSR   DOPROCENTRY
0732 3878                       LONGA OFF
0733 3878                       LONGI OFF
0734 3878 A5 AC 48 A5           PUSH3 <SAVE_DEST               ; Address of result
0735 3881              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0736 3881              ;; DANGER - DANGER - DANGER
0737 3881              ;;   Environment was working strangely.  In old source this was
0738 3881              ;;   PUSH2     <OLD_ENV          with old_env never initialized.
0739 3881              ;;   The change to <save_env looks correct.  It records the initial
0740 3881              ;;   user's environment so it can be restored at resultdelivered.
0741 3881              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0742 3881 A5 69 48 A5           PUSH2 <SAVE_ENV                ; User's environment
0743 3887 A5 B0                 LDA   <SAVE1_CLASS             ; Copy of Source Class
0744 3889 48                    PHA   
0745 388A A5 B1                 LDA   <SAVE1_SIGN
0746 388C 48                    PHA   
0747 388D A5 B2                 LDA   <SAVE2_CLASS             ; Copy of Source2 Class
0748 388F 48                    PHA   
0749 3890 A5 B3                 LDA   <SAVE2_SIGN
0750 3892 48                    PHA   
0751 3893              ;
0752 3893              ; Check for NANs, either SRC2_CLASS (dst/src2) or SRC_CLASS (src) equal to 1
0753 3893              ; or 2.  If the src is a NAN, there might be two NANs so let floating add
0754 3893              ; determine precedence, or propagate the one NAN.  If just the dst
0755 3893              ; (or possible src2) is a NAN, do a simple move, in order to touch
0756 3893              ; any signaling NAN that may have appeared.
0757 3893              ;
0758 3893 A5 6A                 LDA   <SRC_CLASS
0759 3895 C9 FE                 CMP   #FCINF
0760 3897 10 0D                 BPL   NOT2NANS
0761 3899              ; get here is SRC is a NAN
0762 3899 A2 04                 LDX   #F_SRC2
0763 389B 20 A9 3A              JSR   KLUGE8
0764 389E              ;                                       ; Might be dst or src2
0765 389E A2 02                 LDX   #F_SRC
0766 38A0 20 1A 39              JSR   KLUGE97
0767 38A3 4C B5 38              JMP   NANEXIT
0768 38A6 A5 6C        NOT2NANS LDA   <SRC2_CLASS              ; Check src2 or dst
0769 38A8 C9 FE                 CMP   #FCINF
0770 38AA 10 1D                 BPL   LIFTOFF
0771 38AC A2 04                 LDX   #F_SRC2                  ; Src2 or dst addr
0772 38AE A0 00                 LDY   #F_DEST                  ; Dst addr
0773 38B0 A9 0E                 LDA   #FOZ2X
0774 38B2 20 1E 39              JSR   CALL_SANE
0775 38B5 4C 9C 3B     NANEXIT  JMP   RESULTDELIVERED
0776 38B8              ;
0777 38B8                       EXPORT DOPROCENTRY 
0778 38B8              DOPROCENTRY                             ;       ; called in 16-bit mode
0779 38B8                       LONGA ON
0780 38B8                       LONGI ON
0781 38B8 0B                    PHD                            ; save settings of D and B
0782 38B9 8B                    PHB   
0783 38BA F4 00 00              PEA   0                        ; push addr of save_env
0784 38BD 18                    CLC   
0785 38BE 7B                    TDC   
0786 38BF 69 68 00              ADC   #<SAVE_ENV
0787 38C2 48                    PHA   
0788 38C3 A9 17 00              LDA   #FOPROCENTRY             ; invoke procentry
0789 38C6 4C 38 39              JMP   KLUGE2
0790 38C9                       LONGA OFF
0791 38C9                       LONGI OFF
0792 38C9              ;
0793 38C9              ; Fall through to here in typical case of no NANs.
0794 38C9              ; SRC_CLASS and SRC2_CLASS (dst/src2 class) contain the class codes.
0795 38C9              ; Jump to specific routine based on opword in OPCODE
0796 38C9              ;
0797 38C9 A5 62        LIFTOFF  LDA   <OPCODE
0798 38CB 0A                    ASL   A                        ; Get index into table
0799 38CC A8                    TAY   
0800 38CD B9 D7 38              LDA   |ELEMSTAB+1,Y            ; Get address from table and
0801 38D0 48                    PHA                            ; push onto stack
0802 38D1 B9 D6 38              LDA   |ELEMSTAB,Y
0803 38D4 48                    PHA   
0804 38D5 60                    RTS                            ; This RTS causes a jump to
0805 38D6              ;                                       ; the address in the table
0806 38D6              ;                                       ; plus 1.
0807 38D6 EE 3B        ELEMSTAB DC W:LOGTOP-1                  ; LNX
0808 38D8 EE 3B                 DC W:LOGTOP-1                  ; LOG2X
0809 38DA EE 3B                 DC W:LOGTOP-1                  ; LN1X
0810 38DC EE 3B                 DC W:LOGTOP-1                  ; LOG21X
0811 38DE 1B 3D                 DC W:EXPTOP-1                  ; EXPX
0812 38E0 1B 3D                 DC W:EXPTOP-1                  ; EXP2X
0813 38E2 98 3D                 DC W:EXP1TOP-1                 ; EXPX - 1
0814 38E4 98 3D                 DC W:EXP1TOP-1                 ; EXP2X - 1
0815 38E6 59 3E                 DC W:XPWRITOP-1                ; XPWRI
0816 38E8 53 3F                 DC W:XPWRYTOP-1                ; XPWRY
0817 38EA 48 40                 DC W:COMPOUNDTOP-1             ; COMPOUND
0818 38EC B2 40                 DC W:ANNUITYTOP-1              ; ANNUITY
0819 38EE 8D 46                 DC W:ATANTOP-1                 ; ATANX
0820 38F0 ED 44                 DC W:SINTOP-1                  ; SINX
0821 38F2 40 45                 DC W:COSTOP-1                  ; COSX
0822 38F4 03 46                 DC W:TANTOP-1                  ; TANX
0823 38F6 4D 47                 DC W:RANDTOP-1                 ; RANDOMX
0824 38F8                       ENDP 
0825 38F8              ;
0826 38F8              ; END OF FILE
0827 38F8              ;
0828 38F8              ;                  COPY           elems/ELEMCTRL.O.B
0829 38F8              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0830 38F8              ;; File:  ElemCtrl.o.b                                                   ;
0831 38F8              ;; For building 65816 Elems V0.0                                         ;
0832 38F8              ;; Status: First attempt                                                 ;
0833 38F8              ;; Copyright Apple Computer, Inc., 1983-1986                             ;
0834 38F8              ;; All Rights Reserved                                                   ;
0835 38F8              ;;                                                                       ;
0836 38F8              ;; Written by C. Hausmann, 1983                                          ;
0837 38F8              ;;                                                                       ;
0838 38F8              ;; Modification History:                                                 ;
0839 38F8              ;;      24Mar86 CRL     Rewritten for 65816                              ;
0840 38F8              ;;      24Nov86 KLH     Fixed Elems bug                                  ;
0841 38F8              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0842 38F8                       EXPORT KLUGE19 
0843 38F8              KLUGE19  PROC 
0844 38F8                       LONGA OFF
0845 38F8                       LONGI OFF
0846 38F8 A2 0E                 LDX   #F_X
0847 38FA                       EXPORT KLUGE20 
0848 38FA              KLUGE20                                 ;       
0849 38FA A0 00                 LDY   #F_DEST
0850 38FC                       EXPORT KLUGE25 
0851 38FC              KLUGE25                                 ;       
0852 38FC A9 04                 LDA   #FOMUL
0853 38FE D0 1E                 BNE   CALL_SANE
0854 3900                       EXPORT KLUGE22 
0855 3900              KLUGE22                                 ;       
0856 3900 A2 0C                 LDX   #F_W
0857 3902                       EXPORT KLUGE21 
0858 3902              KLUGE21                                 ;       
0859 3902 A0 0E                 LDY   #F_X
0860 3904 D0 F6                 BNE   KLUGE25
0861 3906                       EXPORT KLUGE23 
0862 3906              KLUGE23                                 ;       
0863 3906 A2 28                 LDX   #F_FPKHALF
0864 3908                       EXPORT KLUGE24 
0865 3908              KLUGE24                                 ;       
0866 3908 A0 0C                 LDY   #F_W
0867 390A D0 F0                 BNE   KLUGE25
0868 390C                       EXPORT KLUGE26 
0869 390C              KLUGE26                                 ;       
0870 390C A2 02                 LDX   #F_SRC
0871 390E                       EXPORT KLUGE27 
0872 390E              KLUGE27                                 ;       
0873 390E A0 62                 LDY   #F_ACCUM
0874 3910 D0 EA                 BNE   KLUGE25
0875 3912                       EXPORT KLUGE99 
0876 3912              KLUGE99                                 ;       
0877 3912 A0 00                 LDY   #F_DEST
0878 3914 A9 0C                 LDA   #FOREM
0879 3916 D0 06                 BNE   CALL_SANE
0880 3918                       EXPORT KLUGE96 
0881 3918              KLUGE96                                 ;       
0882 3918 A2 1C                 LDX   #F_FPK1
0883 391A                       EXPORT KLUGE97 
0884 391A              KLUGE97                                 ;       
0885 391A A0 00                 LDY   #F_DEST
0886 391C                       EXPORT KLUGE98 
0887 391C              KLUGE98                                 ;       
0888 391C A9 00                 LDA   #FOADD
0889 391E              ;
0890 391E              ; Routines to invoke a call to the Sane Arithmetic. Two-argument calls only.
0891 391E              ;
0892 391E              ; Input: X reg : Index into table of source address
0893 391E              ;        Y reg : Index into table of dest address
0894 391E              ;        Accum : Function opcode
0895 391E              ;
0896 391E                       EXPORT CALL_SANE 
0897 391E              CALL_SANE                               ;       
0898 391E 85 7C                 STA   <OP0_ADDR                ; Save opcode index
0899 3920                       LONGA ON
0900 3920                       LONGI ON
0901 3920 C2 30                 REP   #$30
0902 3922 0B                    PHD                            ; save settings of D and B
0903 3923 8B                    PHB   
0904 3924 20 A1 39              JSR   CHECKOP
0905 3927 DA                    PHX   
0906 3928 48                    PHA   
0907 3929 BB                    TYX   
0908 392A A0 00 00              LDY   #FFEXT                   ; always extended
0909 392D                       EXPORT LATEKLUGE 
0910 392D              LATEKLUGE                               ;       
0911 392D 20 A1 39              JSR   CHECKOP
0912 3930 DA                    PHX   
0913 3931 48                    PHA   
0914 3932 E2 30                 SEP   #$30
0915 3934                       LONGA OFF
0916 3934                       LONGI OFF
0917 3934 98                    TYA   
0918 3935                       EXPORT KLUGE1 
0919 3935              KLUGE1                                  ;       
0920 3935 48                    PHA   
0921 3936 A5 7C                 LDA   <OP0_ADDR
0922 3938                       EXPORT KLUGE2 
0923 3938              KLUGE2                                  ;       
0924 3938 48                    PHA                            ; Push opcode
0925 3939 C2 30 22 EA           CallFp 
0926 393F E2 30                 SEP   #$30                     ; back to 8-bit mode        
0927 3941                       LONGA OFF
0928 3941                       LONGI OFF
0929 3941 08                    PHP                            ; protect returns in status
0930 3942 68                    PLA                            ;   by holding status in A
0931 3943 AB                    PLB                            ; restore D and DBR
0932 3944 2B                    PLD                            ;   (trashing n and z bits)
0933 3945 48                    PHA                            ; and restore status register
0934 3946 28                    PLP   
0935 3947 60                    RTS   
0936 3948              ;
0937 3948              ; Routines to invoke a call to the Sane Arithmetic. Two-argument calls only.
0938 3948              ;
0939 3948              ; Input: X reg : Index into table of source address
0940 3948              ;        Y reg : Index into table of dest address
0941 3948              ;        Accum : Function opcode
0942 3948              ;
0943 3948                       EXPORT CALLI_SANE 
0944 3948              CALLI_SANE                              ;       
0945 3948 85 7C                 STA   <OP0_ADDR                ; Save opcode index
0946 394A                       LONGA ON
0947 394A                       LONGI ON
0948 394A C2 30                 REP   #$30
0949 394C 0B                    PHD                            ; save settings of D and B
0950 394D 8B                    PHB   
0951 394E 20 A1 39              JSR   CHECKOP
0952 3951 DA                    PHX   
0953 3952 48                    PHA   
0954 3953 BB                    TYX   
0955 3954 A0 04 00              LDY   #FFINT                   ; always integer
0956 3957 80 D4                 BRA   LATEKLUGE
0957 3959              ;
0958 3959              ; Routines to invoke a call to the Sane Arithmetic. One-argument only.
0959 3959              ;
0960 3959              ; Input: X reg : Index into table of dest address
0961 3959              ;        Y reg : Function opcode
0962 3959              ;
0963 3959                       EXPORT CALL1_SANE 
0964 3959              CALL1_SANE                              ;       
0965 3959                       LONGA ON
0966 3959                       LONGI ON
0967 3959 C2 30                 REP   #$30
0968 395B 0B                    PHD                            ; save settings of D and B
0969 395C 8B                    PHB   
0970 395D 20 A1 39              JSR   CHECKOP
0971 3960 DA                    PHX   
0972 3961 48                    PHA   
0973 3962 E2 30                 SEP   #$30
0974 3964                       LONGA OFF
0975 3964                       LONGI OFF
0976 3964 A9 00                 LDA   #FFEXT                   ; Always extended
0977 3966 48                    PHA   
0978 3967 98                    TYA                            ; Opcode
0979 3968 D0 CE                 BNE   KLUGE2
0980 396A              ;
0981 396A              ; Routines to invoke a call to the Sane Arithmetic. One integer value arg.
0982 396A              ;
0983 396A              ; Input: Y reg : Index into table of dest address
0984 396A              ;        X reg : Function opcode
0985 396A              ;
0986 396A                       EXPORT CALL1V_SANE 
0987 396A              CALL1V_SANE                             ;       
0988 396A 64 7E                 STZ   <OP0_ADDR+2              ; address below in bank 0
0989 396C                       LONGA ON
0990 396C                       LONGI ON
0991 396C C2 30                 REP   #$30
0992 396E 0B                    PHD                            ; save settings of D and B
0993 396F 8B                    PHB   
0994 3970 18                    CLC   
0995 3971 7B                    TDC   
0996 3972 79 88 44              ADC   OPERAND,Y                ; an address on direct page
0997 3975 85 7C                 STA   <OP0_ADDR
0998 3977 A7 7C                 LDA   [<OP0_ADDR]              ;   contents of that address
0999 3979 48                    PHA   
1000 397A E2 30                 SEP   #$30
1001 397C                       LONGA OFF
1002 397C                       LONGI OFF
1003 397C A9 04                 LDA   #FFINT                   ; Always integer
1004 397E 48                    PHA   
1005 397F 8A                    TXA                            ; Opcode
1006 3980 4C 38 39              JMP   KLUGE2
1007 3983              ;
1008 3983              ; Routine to call SANE.  Zero argument only.
1009 3983              ;
1010 3983              ; Input: X reg : Index into table of dest address
1011 3983              ;        Y reg : Function opcode
1012 3983              ;
1013 3983                       EXPORT CALL0_SANE 
1014 3983              CALL0_SANE                              ;       
1015 3983                       LONGA ON
1016 3983                       LONGI ON
1017 3983 0B                    PHD                            ; save settings of D and B
1018 3984 8B                    PHB   
1019 3985 98                    TYA   
1020 3986 80 B0                 BRA   KLUGE2
1021 3988                       LONGA OFF
1022 3988                       LONGI OFF
1023 3988              ;
1024 3988              ; Routines to invoke a call to the Elems. One-argument only.
1025 3988              ;
1026 3988              ; Input: X reg : Index into table of dest address
1027 3988              ;        Y reg : Function opcode
1028 3988              ;
1029 3988                       EXPORT KLUGE30 
1030 3988              KLUGE30                                 ;       
1031 3988 A2 62                 LDX   #F_ACCUM
1032 398A                       EXPORT CALL_ELEMS 
1033 398A              CALL_ELEMS                              ;       
1034 398A                       LONGA ON
1035 398A                       LONGI ON
1036 398A C2 30                 REP   #$30
1037 398C 0B                    PHD                            ; save settings of D and B
1038 398D 8B                    PHB   
1039 398E 20 A1 39              JSR   CHECKOP
1040 3991 DA                    PHX   
1041 3992 48                    PHA   
1042 3993 5A                    PHY                            ; opcode in Y, hi byte xx
1043 3994 E2 30                 SEP   #$30
1044 3996 C2 30 22 E5           CallEl 
1045 399C AB                    PLB                            ; restore D and DBR
1046 399D 2B                    PLD   
1047 399E E2 30                 SEP   #$30
1048 39A0                       LONGA OFF
1049 39A0                       LONGI OFF
1050 39A0 60                    RTS   
1051 39A1              ;
1052 39A1              ; Checkop computes a 4 byte address from a single byte index
1053 39A1              ;
1054 39A1              ;           Input:  X = offset into table of addresses at OPERAND
1055 39A1              ;           Output: A = low word of required 4 byte address
1056 39A1              ;                   X =  hi word of required 4 byte address
1057 39A1              ;
1058 39A1              ; The routine must distinguish between ROM addresses and direct page addresses.
1059 39A1
1060 39A1              ;           Direct page addresses are:  0-word,  D + value at OPERAND,X.
1061 39A1              ;           ROM addresses are:          0-byte,  DBR-byte,  value at OPERAND,X.
1062 39A1              ;
1063 39A1                       EXPORT CHECKOP 
1064 39A1              CHECKOP                                 ;       
1065 39A1 08                    PHP                            ; save operating state
1066 39A2 E2 30                 SEP   #$30
1067 39A4 E0 14                 CPX   #F_LOG21P                ; is x between 0 and 18?
1068 39A6 90 10                 BCC   AddD                     ;   if so, it's in direct page
1069 39A8 E0 5C                 CPX   #F_EXCPTION              ; is x between 92 and 98?
1070 39AA B0 0C                 BCS   AddD                     ;   if so, it's in direct page
1071 39AC A9 00                 LDA   #0                       ; ADDRESS IN ROM
1072 39AE 48                    PHA                            ; 4th byte of address is 0
1073 39AF C2 30                 REP   #$30
1074 39B1                       LONGA ON
1075 39B1                       LONGI ON
1076 39B1 BD 88 44              LDA   OPERAND,X                ; collect low word of address
1077 39B4 8B                    PHB                            ; 3rd byte of address is DBR
1078 39B5 FA                    PLX                            ; pull hi word of address: 0,DBR
1079 39B6 80 0A                 BRA   ENDCHECK
1080 39B8 C2 30        AddD     REP   #$30                     ; ADDRESS IN DIRECT PAGE
1081 39BA 18                    CLC                            ;   and compute direct page addr
1082 39BB 7B                    TDC   
1083 39BC 7D 88 44              ADC   OPERAND,X                ; address low = D + offset
1084 39BF A2 00 00              LDX   #0                       ; address hi is 0
1085 39C2 28           ENDCHECK PLP                            ; restore operating state
1086 39C3 60                    RTS   
1087 39C4                       ENDP 
1088 39C4              ;
1089 39C4              ; Utility to evaluate a polynomial using Horner's recurrence.
1090 39C4              ; Input:  Parameters are passed via zero-page registers 10-14
1091 39C4              ;         A0_ADDR   pts to result field (preserved)
1092 39C4              ;         OP1_ADDR  pts to coefficient table (advanced beyond table).
1093 39C4              ;         A2_ADDR   pts to function value (preserved).
1094 39C4              ; Uses:   X,Y registers
1095 39C4              ; All operands are extended.  The polynomial table consists of
1096 39C4              ; a leading word N, a positive integer giving the degree of the
1097 39C4              ; polynomial, and then (N+1) extended coefficients, starting with
1098 39C4              ; that of the leading term.
1099 39C4              ; RESULT  <-- C0  initially.
1100 39C4              ; RESULT  <-- (RESULT * X) + CJ   for J = 1 to DEGREE
1101 39C4              ; Since OP1_ADDR is advanced beyond the end of the given coefficient table,
1102 39C4              ; POLYEVAL may be used sucessively with consecutive tables, after setting
1103 39C4              ; OP1_ADDR just once.
1104 39C4              ;
1105 39C4                       EXPORT KLUGE35 
1106 39C4              KLUGE35  PROC                           ; 12MAY86 uncalled????
1107 39C4                       LONGA OFF
1108 39C4                       LONGI OFF
1109 39C4              ;               LDA	            OPERAND+1,Y
1110 39C4              ;               STA	            <OP1_ADDR+1
1111 39C4              ;               LDA	            OPERAND,Y
1112 39C4              ;               STA	            <OP1_ADDR
1113 39C4              ;               RTS
1114 39C4                       EXPORT KLUGE29 
1115 39C4              KLUGE29                                 ;       
1116 39C4 A9 0E                 LDA   #F_X
1117 39C6 D0 0A                 BNE   POLYEVAL
1118 39C8                       EXPORT KLUGE32 
1119 39C8              KLUGE32                                 ;       
1120 39C8 A2 0E                 LDX   #F_X
1121 39CA A9 10                 LDA   #F_Y
1122 39CC D0 04                 BNE   POLYEVAL
1123 39CE                       EXPORT KLUGE33 
1124 39CE              KLUGE33                                 ;       
1125 39CE A9 0C                 LDA   #F_W
1126 39D0 A4 C3                 LDY   <I_TEMP
1127 39D2              ; Evaluates a polynomial in T by Horner's recursion.  Each loop uses 3 variables:
1128 39D2              ;
1129 39D2              ;               VARIABLE        INDEX REG       POINTER         LOCATION
1130 39D2              ;               ------------------------------------------------
1131 39D2              ;               T               A               OP0_ADDR        direct page
1132 39D2              ;               Coeff           Y               OP1_ADDR        ROM
1133 39D2              ;               Result          X               A0_ADDR         direct page
1134 39D2                       EXPORT POLYEVAL 
1135 39D2              POLYEVAL                                ;       
1136 39D2                       LONGA ON
1137 39D2                       LONGI ON
1138 39D2 C2 30                 REP   #$30
1139 39D4 29 FF 00              AND   #$00FF                   ; KLH 24Nov86
1140 39D7 85 7C                 STA   <OP0_ADDR                ; save index of result
1141 39D9 18                    CLC   
1142 39DA 7B                    TDC   
1143 39DB 7D 88 44              ADC   OPERAND,X                ; copy result address to A0
1144 39DE 85 EF                 STA   <A0_ADDR
1145 39E0 B9 88 44              LDA   OPERAND,Y                ; copy address of coeffs to op1
1146 39E3 85 7F                 STA   <OP1_ADDR
1147 39E5 A6 7C                 LDX   <OP0_ADDR                ; retrieve result index
1148 39E7 18                    CLC   
1149 39E8 7B                    TDC   
1150 39E9 7D 88 44              ADC   OPERAND,X                ; copy address of argument X
1151 39EC 85 7C                 STA   <OP0_ADDR
1152 39EE E2 30                 SEP   #$30
1153 39F0                       LONGA OFF
1154 39F0                       LONGI OFF
1155 39F0 A0 00                 LDY   #0
1156 39F2 B1 7F                 LDA   (<OP1_ADDR),Y            ; copy #coeffs to D0
1157 39F4 85 F2                 STA   <D0_TEMP
1158 39F6 A2 02                 LDX   #$2                      ; point to 1st coeff,
1159 39F8 A0 0E                 LDY   #FOZ2X                   ;   copy it to result
1160 39FA 20 0E 3A              JSR   KLUGE10
1161 39FD                       EXPORT POLYLOOP 
1162 39FD              POLYLOOP                                ;       
1163 39FD A0 04                 LDY   #FOMUL
1164 39FF 20 34 3A              JSR   KLUGE12
1165 3A02 A2 0A                 LDX   #EXT_SIZE
1166 3A04 A0 00                 LDY   #FOADD
1167 3A06 20 0E 3A              JSR   KLUGE10
1168 3A09 C6 F2                 DEC   <D0_TEMP
1169 3A0B D0 F0                 BNE   POLYLOOP
1170 3A0D 60                    RTS   
1171 3A0E                       EXPORT KLUGE10 
1172 3A0E              KLUGE10                                 ;       
1173 3A0E 18                    CLC   
1174 3A0F 8A                    TXA   
1175 3A10 65 7F                 ADC   <OP1_ADDR                ; 3rd byte of OP1 = DBR
1176 3A12 85 7F                 STA   <OP1_ADDR
1177 3A14 A5 80                 LDA   <OP1_ADDR+1
1178 3A16 69 00                 ADC   #$0
1179 3A18 85 80                 STA   <OP1_ADDR+1
1180 3A1A A2 00                 LDX   #$0                      ; push 4 byte address of OP1
1181 3A1C 0B                    PHD                            ; save D and B before fp call
1182 3A1D 8B                    PHB   
1183 3A1E DA                    PHX   
1184 3A1F 8B                    PHB                            ; OP1 pts to a constant in ROM
1185 3A20 48                    PHA   
1186 3A21 A5 7F                 LDA   <OP1_ADDR
1187 3A23                       EXPORT KLUGE11 
1188 3A23              KLUGE11                                 ;       
1189 3A23 48                    PHA   
1190 3A24 F4 00 00              PEA   0                        ; push zero page address of A0
1191 3A27 A5 F0                 LDA   <A0_ADDR+1
1192 3A29 48                    PHA   
1193 3A2A A5 EF                 LDA   <A0_ADDR
1194 3A2C 48                    PHA   
1195 3A2D A9 00                 LDA   #FFEXT                   ; push opword and call engine
1196 3A2F 48                    PHA   
1197 3A30 98                    TYA   
1198 3A31 4C 38 39              JMP   KLUGE2
1199 3A34                       EXPORT KLUGE12 
1200 3A34              KLUGE12                                 ;
1201 3A34 0B                    PHD                            ; save B and D before fp call
1202 3A35 8B                    PHB   
1203 3A36 F4 00 00              PEA   0                        ; push zero page address of op0
1204 3A39 A5 7D                 LDA   <OP0_ADDR+1
1205 3A3B 48                    PHA   
1206 3A3C A5 7C                 LDA   <OP0_ADDR
1207 3A3E 80 E3                 BRA   KLUGE11
1208 3A40              ;
1209 3A40              ; Clear the exception flag by getting, tweaking, and restoring the
1210 3A40              ; environment word.
1211 3A40              ; Input:  EXCPTION = exception bit index
1212 3A40              ; Uses:   J_ADDR
1213 3A40              ;
1214 3A40                       EXPORT CLEARUFLOW 
1215 3A40              CLEARUFLOW                              ;
1216 3A40 A9 02                 LDA   #FBUFLOW
1217 3A42 D0 0A                 BNE   CLEARX2
1218 3A44                       EXPORT CLEAROFLOW 
1219 3A44              CLEAROFLOW                              ;
1220 3A44 A9 04                 LDA   #FBOFLOW
1221 3A46 D0 06                 BNE   CLEARX2
1222 3A48                       EXPORT CLEARINVALID 
1223 3A48              CLEARINVALID                            ;
1224 3A48 A9 01                 LDA   #FBINVALID
1225 3A4A D0 02                 BNE   CLEARX2
1226 3A4C                       EXPORT CLRINEXACT 
1227 3A4C              CLRINEXACT                              ;
1228 3A4C A9 10                 LDA   #FBINEXACT
1229 3A4E 85 64        CLEARX2  STA   <EXCPTION
1230 3A50
1231 3A50                       EXPORT CLEARX 
1232 3A50              CLEARX                                  ;
1233 3A50                       LONGA ON
1234 3A50                       LONGI ON
1235 3A50 C2 30                 REP   #$30                     ; 16 bit mode
1236 3A52 A0 03 00              LDY   #FOGETENV                ; Get environment word -
1237 3A55 20 83 39              JSR   CALL0_SANE               ;   returned in X and Y
1238 3A58                       LONGA OFF
1239 3A58                       LONGI OFF
1240 3A58 86 C5                 STX   <J_TEMP
1241 3A5A 84 C6                 STY   <J_TEMP+1                ; exceptions in hi byte
1242 3A5C A5 64                 LDA   <EXCPTION
1243 3A5E 49 FF                 EOR   #FFMask                  ; Complement excption
1244 3A60 25 C6                 AND   <J_TEMP+1                ; Turn off excption
1245 3A62 85 C6                 STA   <J_TEMP+1
1246 3A64 0B                    PHD                            ; save B and D before fp call
1247 3A65 8B                    PHB   
1248 3A66 A5 C6                 LDA   <J_TEMP+1                ; Try this..
1249 3A68 48                    PHA   
1250 3A69 A5 C5                 LDA   <J_TEMP
1251 3A6B 48                    PHA   
1252 3A6C 48                    PHA   
1253 3A6D A9 01                 LDA   #FOSETENV
1254 3A6F 4C 38 39              JMP   KLUGE2
1255 3A72              ;
1256 3A72              ; Utility to force a flag.
1257 3A72              ; Uses: EXCPTION.
1258 3A72              ;
1259 3A72                       EXPORT FORCEOFLOW 
1260 3A72              FORCEOFLOW                              ;
1261 3A72 A9 04                 LDA   #FBOFLOW
1262 3A74 D0 0E                 BNE   FORCEX2
1263 3A76                       EXPORT FORCEUFLOW 
1264 3A76              FORCEUFLOW                              ;
1265 3A76 A9 02                 LDA   #FBUFLOW
1266 3A78 D0 0A                 BNE   FORCEX2
1267 3A7A                       EXPORT FORCEDIVZER 
1268 3A7A              FORCEDIVZER                             ;
1269 3A7A A9 08                 LDA   #FBDIVZER
1270 3A7C D0 06                 BNE   FORCEX2
1271 3A7E                       EXPORT FORCEINVALID 
1272 3A7E              FORCEINVALID                            ;
1273 3A7E A9 01                 LDA   #FBINVALID
1274 3A80 D0 02                 BNE   FORCEX2
1275 3A82                       EXPORT FORCEINEXACT 
1276 3A82              FORCEINEXACT                            ;
1277 3A82 A9 10                 LDA   #FBINEXACT
1278 3A84 85 64        FORCEX2  STA   <EXCPTION
1279 3A86                       EXPORT FORCEX 
1280 3A86              FORCEX                                  ;
1281 3A86 A2 15                 LDX   #FOSETXCP
1282 3A88 D0 16                 BNE   TESTX1
1283 3A8A              ;
1284 3A8A              ; Utility to test an exception flag.
1285 3A8A              ; Output: Z flag in Status register is set if exception flag is off, Z is
1286 3A8A              ; 0 if flag is on.
1287 3A8A              ;
1288 3A8A                       EXPORT TESTUFLOW 
1289 3A8A              TESTUFLOW                               ;
1290 3A8A A9 02                 LDA   #FBUFLOW
1291 3A8C D0 0E                 BNE   TESTX2
1292 3A8E                       EXPORT TESTOFLOW 
1293 3A8E              TESTOFLOW                               ;
1294 3A8E A9 04                 LDA   #FBOFLOW
1295 3A90 D0 0A                 BNE   TESTX2
1296 3A92                       EXPORT TESTDIVZER 
1297 3A92              TESTDIVZER                              ;
1298 3A92 A9 08                 LDA   #FBDIVZER
1299 3A94 D0 06                 BNE   TESTX2
1300 3A96                       EXPORT TESTINVALID 
1301 3A96              TESTINVALID                             ;
1302 3A96 A9 01                 LDA   #FBINVALID
1303 3A98 D0 02                 BNE   TESTX2
1304 3A9A                       EXPORT TESTINEXACT 
1305 3A9A              TESTINEXACT                             ;
1306 3A9A A9 10                 LDA   #FBINEXACT
1307 3A9C 85 64        TESTX2   STA   <EXCPTION
1308 3A9E                       EXPORT TESTX 
1309 3A9E              TESTX                                   ;
1310 3A9E A2 1B                 LDX   #FOTESTXCP
1311 3AA0 A9 00        TESTX1   LDA   #$0
1312 3AA2 85 65                 STA   <EXCPTION+1
1313 3AA4                       EXPORT KLUGE31 
1314 3AA4              KLUGE31                                 ;
1315 3AA4 A0 5C                 LDY   #F_EXCPTION
1316 3AA6 4C 6A 39              JMP   CALL1V_SANE              ; Clears Z flag if exception
1317 3AA9              ;
1318 3AA9              ;               This routine copies one extended value to another.
1319 3AA9              ;               x -> y where y is always on direct page, but x can
1320 3AA9              ;               be in direct or rom.  x is determined by the offset
1321 3AA9              ;               in the X register.  For x = 0..18 or 92..98, the
1322 3AA9              ;               address is direct page, otherwise rom.
1323 3AA9              ;
1324 3AA9                       EXPORT KLUGE8 
1325 3AA9              KLUGE8                                  ;
1326 3AA9 A0 00                 LDY   #F_DEST
1327 3AAB                       EXPORT MOVEIT 
1328 3AAB              MOVEIT                                  ;
1329 3AAB 20 A1 39              JSR   CHECKOP                  ; return address for x in X & A
1330 3AAE 85 7C                 STA   <OP0_ADDR
1331 3AB0 EB                    XBA   
1332 3AB1 85 7D                 STA   <OP0_ADDR+1
1333 3AB3 86 7E                 STX   OP0_ADDR+2
1334 3AB5 64 81                 STZ   <OP1_ADDR+2
1335 3AB7                       LONGA ON
1336 3AB7                       LONGI ON
1337 3AB7 C2 30                 REP   #$30
1338 3AB9 18                    CLC   
1339 3ABA 7B                    TDC   
1340 3ABB 79 88 44              ADC   OPERAND,Y
1341 3ABE 85 7F                 STA   <OP1_ADDR
1342 3AC0 A0 08 00              LDY   #$8
1343 3AC3 B7 7C        Z1S04    LDA   [<OP0_ADDR],Y
1344 3AC5 97 7F                 STA   [<OP1_ADDR],Y
1345 3AC7 88                    DEY   
1346 3AC8 88                    DEY   
1347 3AC9 10 F8                 BPL   z1s04
1348 3ACB E2 30                 SEP   #$30
1349 3ACD                       LONGI OFF
1350 3ACD                       LONGA OFF
1351 3ACD 60                    RTS   
1352 3ACE              ;
1353 3ACE              ; This routine negates an integer.  Integer must be in J_TEMP
1354 3ACE              ;
1355 3ACE                       EXPORT NEGATE 
1356 3ACE              NEGATE                                  ;
1357 3ACE 38                    SEC   
1358 3ACF A9 00                 LDA   #$0
1359 3AD1 E5 C5                 SBC   <J_TEMP
1360 3AD3 85 C5                 STA   <J_TEMP
1361 3AD5 A9 00                 LDA   #$0
1362 3AD7 E5 C6                 SBC   <J_TEMP+1
1363 3AD9 85 C6                 STA   <J_TEMP+1
1364 3ADB 60                    RTS   
1365 3ADC                       ENDP 
1366 3ADC              ;
1367 3ADC              ; END OF FILE
1368 3ADC              ;
1369 3ADC              ; Log
1370 3ADC              ;                  COPY           elems/ELEM1.O
1371 3ADC              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
1372 3ADC              ;; File:  Elem1.o                                                        ;
1373 3ADC              ;; For building 65816 Elems V0.0                                         ;
1374 3ADC              ;; Status: First attempt                                                 ;
1375 3ADC              ;; Copyright Apple Computer, Inc., 1983-1986                             ;
1376 3ADC              ;; All Rights Reserved                                                   ;
1377 3ADC              ;;                                                                       ;
1378 3ADC              ;; Written by C. Hausmann, 1983                                          ;
1379 3ADC              ;;                                                                       ;
1380 3ADC              ;; Modification History:                                                 ;
1381 3ADC              ;;      24Mar86 CRL     Rewritten for 65816                              ;
1382 3ADC              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
1383 3ADC              ;
1384 3ADC              ; Floating scalb function computes (A0)  <--  (A0) * 2^(A1)
1385 3ADC              ; Because of the 15-bit exponent range, just two invocations
1386 3ADC              ; of FSCALBX are required if an over/underflow is to be simulated.
1387 3ADC              ; (A0) and (A1) are passed via zero-page registers
1388 3ADC              ; A0_ADDR, A1_ADDR are not modified.
1389 3ADC              ; Uses:  J_TEMP,
1390 3ADC              ;        Y_ADDR (pointer to extended temporary)
1391 3ADC              ;
1392 3ADC                       EXPORT SCALBXX 
1393 3ADC              SCALBXX  PROC 
1394 3ADC                       LONGA OFF
1395 3ADC                       LONGI OFF
1396 3ADC AD EE 42 85           MOVE2 F_MAXINT,<J_TEMP
1397 3AE6 DA A0 09 BB  Z2S000   COPY_EXTEND <OP1_ADDR,<Y_TEMP
1398 3AF3 A2 10                 LDX   #F_Y
1399 3AF5 20 D4 3E              JSR   KLUGE68
1400 3AF8              ;
1401 3AF8              ; if (SP) is larger than MAXINT then do one step of scaling by MAXINT.
1402 3AF8              ;
1403 3AF8 20 4C 3B              JSR   VSMAXINT
1404 3AFB 70 0C F0 0A           FBGE Z2S00
1405 3AFF              ;
1406 3AFF              ; Must diminish (Y) by FPKMAXINT.
1407 3AFF              ;
1408 3AFF A2 24                 LDX   #F_FPKMAXINT
1409 3B01 A0 10                 LDY   #F_Y
1410 3B03 20 73 3D              JSR   KLUGE91
1411 3B06 20 3D 3B              JSR   KLUGE13
1412 3B09              ;
1413 3B09              ; If (SP) exceeds FPKMAXINT at this step, just force signed FPKMAXINT
1414 3B09              ;
1415 3B09 20 4C 3B     Z2S00    JSR   VSMAXINT                 ; (SP) vs. FPKMAXINT
1416 3B0C 70 07 F0 05           FBGE z2s01
1417 3B10 A2 24                 LDX   #F_FPKMAXINT
1418 3B12 4C 17 3B              JMP   z2s03
1419 3B15 A2 10        Z2S01    LDX   #F_Y
1420 3B17 A0 0A        Z2S03    LDY   #F_J                     ; Index of addrss of MAXINT or
1421 3B19              ;                                       ; -MAXINT
1422 3B19 A9 10                 LDA   #FOX2Z                   ; Convert reduced value to
1423 3B1B              ;                                       ; integer data type
1424 3B1B 20 48 39              JSR   CALLI_SANE
1425 3B1E 4C 3D 3B              JMP   KLUGE13
1426 3B21                       ENDP 
1427 3B21              ;
1428 3B21              ; Scale (A0) by integer in JTEMP
1429 3B21              ;
1430 3B21                       EXPORT SCALEINT 
1431 3B21              SCALEINT PROC 
1432 3B21                       LONGA OFF
1433 3B21                       LONGI OFF
1434 3B21 0B                    PHD                            ; save settings of D and B
1435 3B22 8B                    PHB   
1436 3B23 A5 C6 48 A5           PUSH2 <J_TEMP                  ; DANGER!! we are pushing
1437 3B29              ;                                       ; a value -- not an address
1438 3B29              ;                                       ; here!
1439 3B29 A9 00 48 A5           PUSH4 <A0_ADDR
1440 3B35 A9 00                 LDA   #0
1441 3B37 48                    PHA   
1442 3B38 A9 18                 LDA   #FOSCALB
1443 3B3A 4C 38 39              JMP   KLUGE2
1444 3B3D                       EXPORT KLUGE13 
1445 3B3D              KLUGE13                                 ;       
1446 3B3D                       LONGA ON
1447 3B3D                       LONGI ON
1448 3B3D C2 30                 REP   #$30
1449 3B3F A6 7F                 LDX   <OP1_ADDR
1450 3B41 20 30 38              JSR   CLASS_2                  ; Check operand sign
1451 3B44                       LONGA OFF
1452 3B44                       LONGI OFF
1453 3B44 10 03                 FBPLUS z3s01
1454 3B46 20 CE 3A              JSR   NEGATE                   ; Negate MAXINT
1455 3B49 4C 21 3B     Z3S01    JMP   SCALEINT                 ; Scale (A0) by MAXINT or
1456 3B4C              ;                                       ; -MAXINT
1457 3B4C              ;
1458 3B4C              ; Compare extended value with FPKMAXINT
1459 3B4C              ;
1460 3B4C                       EXPORT VSMAXINT 
1461 3B4C              VSMAXINT                                ;       
1462 3B4C A2 24                 LDX   #F_FPKMAXINT
1463 3B4E A0 10                 LDY   #F_Y
1464 3B50                       EXPORT KLUGE28 
1465 3B50              KLUGE28                                 ;       
1466 3B50 A9 08                 LDA   #FOCMP
1467 3B52 4C 1E 39              JMP   CALL_SANE
1468 3B55                       ENDP 
1469 3B55              ;
1470 3B55              ; Trailing stubs to deal with special values to be delivered.
1471 3B55              ;
1472 3B55                       EXPORT POSTUFF 
1473 3B55              POSTUFF  PROC 
1474 3B55                       LONGA OFF
1475 3B55                       LONGI OFF
1476 3B55 A2 3A                 LDX   #F_FPK0
1477 3B57 D0 18                 BNE   KLUGE7
1478 3B59                       EXPORT MOSTUFF 
1479 3B59              MOSTUFF                                 ;       
1480 3B59 A2 3C                 LDX   #F_FPKM0
1481 3B5B D0 14                 BNE   KLUGE7
1482 3B5D                       EXPORT P1STUFF 
1483 3B5D              P1STUFF                                 ;       
1484 3B5D A2 1C                 LDX   #F_FPK1
1485 3B5F D0 10                 BNE   KLUGE7
1486 3B61                       EXPORT M1STUFF 
1487 3B61              M1STUFF                                 ;       
1488 3B61 A2 1E                 LDX   #F_FPKM1
1489 3B63 D0 0C                 BNE   KLUGE7
1490 3B65                       EXPORT DIVPOSTUFF 
1491 3B65              DIVPOSTUFF                              ;       
1492 3B65 20 7A 3A              JSR   FORCEDIVZER
1493 3B68                       EXPORT PINFSTUFF 
1494 3B68              PINFSTUFF                               ;       
1495 3B68 A2 3E                 LDX   #F_FPKINF
1496 3B6A D0 05                 BNE   KLUGE7
1497 3B6C                       EXPORT DIVMOSTUFF 
1498 3B6C              DIVMOSTUFF                              ;       
1499 3B6C 20 7A 3A              JSR   FORCEDIVZER
1500 3B6F                       EXPORT MINFSTUFF 
1501 3B6F              MINFSTUFF                               ;       
1502 3B6F A2 40                 LDX   #F_FPKMINF
1503 3B71                       EXPORT KLUGE7 
1504 3B71              KLUGE7                                  ;       
1505 3B71 20 A9 3A              JSR   KLUGE8
1506 3B74 4C 9C 3B              JMP   RESULTDELIVERED
1507 3B77                       ENDP 
1508 3B77              ;
1509 3B77              ; Fabricate a silent NAN, set Invalid, and deliver to destination.
1510 3B77              ;
1511 3B77                       EXPORT ERRORNAN 
1512 3B77              ERRORNAN PROC 
1513 3B77                       LONGA OFF
1514 3B77                       LONGI OFF
1515 3B77 A5 6F                 LDA   <CLASS_SIGN              ; 0=positive,1=negative
1516 3B79 D0 05                 BNE   z4s099
1517 3B7B A9 7F                 LDA   #$7F
1518 3B7D 4C 82 3B              JMP   z4s088
1519 3B80 A9 FF        Z4S099   LDA   #FFMask
1520 3B82 85 8B        Z4S088   STA   <DEST+9
1521 3B84 A9 FF                 LDA   #FFMask
1522 3B86 85 8A                 STA   <DEST+8
1523 3B88 A9 40                 LDA   #$40
1524 3B8A 85 89                 STA   <DEST+7
1525 3B8C A5 6E                 LDA   <CLASS_CODE
1526 3B8E 85 88                 STA   <DEST+6
1527 3B90 A9 00                 LDA   #$0
1528 3B92 A2 05                 LDX   #$5                      ; Byte count
1529 3B94 95 82        Z4S09    STA   <DEST,X
1530 3B96 CA                    DEX   
1531 3B97 10 FB                 BPL   z4s09
1532 3B99 20 7E 3A              JSR   FORCEINVALID
1533 3B9C              ;
1534 3B9C              ; Finally, a result has been placed in DEST.  Restore the environment,
1535 3B9C              ; signalling any required exceptions, restore the registers.
1536 3B9C              ;
1537 3B9C                       EXPORT RESULTDELIVERED 
1538 3B9C              RESULTDELIVERED                         ;       
1539 3B9C 68                    PLA   
1540 3B9D 85 6D                 STA   <SRC2_SIGN
1541 3B9F 68                    PLA   
1542 3BA0 85 6C                 STA   <SRC2_CLASS
1543 3BA2 68                    PLA   
1544 3BA3 85 6B                 STA   <SRC_SIGN
1545 3BA5 68                    PLA   
1546 3BA6 85 6A                 STA   <SRC_CLASS
1547 3BA8 68 85 66 68           POP2 <OLD_ENV
1548 3BAE 68 85 AA 68           POP3 <SAVE_DEST
1549 3BB7 A0 09                 LDY   #EXT_LEN                 ; return result
1550 3BB9 DA                    PHX   
1551 3BBA BB                    TYX   
1552 3BBB B5 82        Z5S10    LDA   <DEST,X
1553 3BBD 97 AA                 STA   [<SAVE_DEST],Y
1554 3BBF 88                    DEY   
1555 3BC0 CA                    DEX   
1556 3BC1 10 F8                 BPL   z5s10
1557 3BC3 FA                    PLX   
1558 3BC4              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
1559 3BC4              ;; Note sleazy ending.  Pick up return addresses from stack,
1560 3BC4              ;;    then push original saved environment, push procexit opcode,
1561 3BC4              ;;    and invoke PROCEXIT:  not by JSR, but instead by pushing
1562 3BC4              ;;    original return addresses from stack at entry to elems call
1563 3BC4              ;;    and doing a jump to the FP code.
1564 3BC4              ;; In this way, all elems calls go out through the FP back end.
1565 3BC4              ;;    This ought to make SANE look like a one entry, one exit
1566 3BC4              ;;    piece of code.  Halt mechanism writers may even like it!
1567 3BC4              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
1568 3BC4                       LONGA ON
1569 3BC4                       LONGI ON
1570 3BC4 C2 30                 REP   #$30
1571 3BC6 68                    PLA   
1572 3BC7 85 EF                 STA   A0_ADDR
1573 3BC9 68                    PLA   
1574 3BCA 85 F1                 STA   A0_ADDR+2
1575 3BCC 68                    PLA   
1576 3BCD 85 F3                 STA   A0_ADDR+4
1577 3BCF              ;
1578 3BCF A5 66                 LDA   <OLD_ENV
1579 3BD1 48                    PHA   
1580 3BD2 F4 19 00              PEA   FOPROCEXIT
1581 3BD5              ;
1582 3BD5 A5 F3                 LDA   A0_ADDR+4
1583 3BD7 48                    PHA   
1584 3BD8 A5 F1                 LDA   A0_ADDR+2
1585 3BDA 48                    PHA   
1586 3BDB A5 EF                 LDA   A0_ADDR
1587 3BDD 48                    PHA   
1588 3BDE              ;
1589 3BDE 22 68 00 E1           JSL   DecBusyFlg               ; TEMPORARILY ZERO!!!!
1590 3BE2 4C F9 1B              JMP   Clayton
1591 3BE5              ;
1592 3BE5              ; Two short routines used to call FP and Elems from inside the code itself.
1593 3BE5              ;   Each fakes up 2 return addresses so dispatcher can be avoided.
1594 3BE5              ;
1595 3BE5                       EXPORT Call_El 
1596 3BE5              Call_El                                 ;       
1597 3BE5 22 6D 37 FC           JSL   PrivateEntry
1598 3BE9 6B                    RTL   
1599 3BEA                       EXPORT Call_Fp 
1600 3BEA              Call_Fp                                 ;       
1601 3BEA 22 F9 1B FC           JSL   Clayton
1602 3BEE 6B                    RTL   
1603 3BEF                       ENDP 
1604 3BEF              ;
1605 3BEF              ; Logarithm functions
1606 3BEF              ; All four functions  LN(x), LOG2(x), LN(1+x), and LOG2(1+X)
1607 3BEF              ; are launched by common error-checking code.  In the usual case
1608 3BEF              ; that arithmetic is required, the computation is cast in the form
1609 3BEF              ; log2(1+z).  The only difference between LN and LOG2 is that the
1610 3BEF              ; former requires a final multiplication by LN(2).
1611 3BEF              ;
1612 3BEF              ; The four functions are distinguished by the BTLOGBASE2 and
1613 3BEF              ; BDLOG1PLUSX bits as described in the EQU section above.
1614 3BEF              ;
1615 3BEF              ; Since the only operand is the destination, the relevant class code
1616 3BEF              ; (already diminished by FCINF in the NAN check) is in SRC2_CLASS.
1617 3BEF              ; SRC2_CLASS corresponds to D1.B in Jerome's version of the Elems.
1618 3BEF              ;
1619 3BEF              ; 6502 vs 68000 version naming conventions:
1620 3BEF              ;
1621 3BEF              ; OPCODE       <-->     D3.W
1622 3BEF              ; DEST         <-->     (A4)    { equivalent also to SRC2_PTR }
1623 3BEF              ; SRC2_CLASS   <-->     D1.B
1624 3BEF              ; SRC2_SIGN    <-->     D1.W
1625 3BEF              ;
1626 3BEF                       EXPORT LOGTOP 
1627 3BEF              LOGTOP   PROC 
1628 3BEF                       LONGA OFF
1629 3BEF                       LONGI OFF
1630 3BEF A5 6C                 LDA   <SRC2_CLASS
1631 3BF1 C9 FE                 CMP   #FCINF
1632 3BF3 F0 11                 BEQ   LOGINFIN
1633 3BF5              ;
1634 3BF5              ; Finite case
1635 3BF5 A9 02                 LDA   #BTLOG1PLUSX
1636 3BF7 24 62                 BIT   <OPCODE
1637 3BF9 D0 1D                 BNE   LOG1PLUSX
1638 3BFB A5 6C                 LDA   <SRC2_CLASS
1639 3BFD 30 2F                 BMI   LOGO
1640 3BFF              ;                                       ; -INF, with divide by 0
1641 3BFF A5 6D                 LDA   <SRC2_SIGN               ; Check sign
1642 3C01              ;                                       ; 0=positive, 80 (hex)=negative
1643 3C01 30 0A                 BMI   LOGERROR
1644 3C03 4C 72 3C              JMP   LOG2R
1645 3C06              ;
1646 3C06              ; case - Log for infinite value
1647 3C06              ;
1648 3C06                       EXPORT LOGINFIN 
1649 3C06              LOGINFIN                                ;       
1650 3C06 A5 6D                 LDA   <SRC2_SIGN               ; 0-pos, 1-neg
1651 3C08 D0 03                 BNE   LOGERROR
1652 3C0A 4C 68 3B              JMP   PINFSTUFF                ; Log(+INF) is +INF
1653 3C0D                       EXPORT LOGERROR 
1654 3C0D              LOGERROR                                ;       
1655 3C0D A5 6D                 LDA   <SRC2_SIGN
1656 3C0F 85 6F                 STA   <CLASS_SIGN
1657 3C11 A9 24                 LDA   #NANLOG                  ; Error code
1658 3C13 85 6E                 STA   <CLASS_CODE
1659 3C15 4C 77 3B              JMP   ERRORNAN                 ; Log (-INF) is an error
1660 3C18                       EXPORT LOG1PLUSX 
1661 3C18              LOG1PLUSX                               ;       
1662 3C18 A5 6C                 LDA   <SRC2_CLASS
1663 3C1A 10 03                 BPL   z6s06
1664 3C1C              ;                                       ; is 0 if operand is 0
1665 3C1C 4C 9C 3B              JMP   RESULTDELIVERED
1666 3C1F              ;                                       ; LOG(+-0) is +-0
1667 3C1F A2 1E        Z6S06    LDX   #F_FPKM1
1668 3C21 A0 00                 LDY   #F_DEST
1669 3C23 20 50 3B              JSR   KLUGE28
1670 3C26 70 E5 30 02           FBUGT LOGERROR                 ; if -1 > operand, then error
1671 3C2C 30 03                 FBLT LOG12R                    ; Find LOG (1+x)
1672 3C2E              ;                                       ; Fall through when = -1
1673 3C2E                       EXPORT LOGO 
1674 3C2E              LOGO                                    ;       
1675 3C2E 4C 6C 3B              JMP   DIVMOSTUFF               ; End of special cases
1676 3C31              ;
1677 3C31              ; Compute LOG2(1 + T) for some positive, finite T.
1678 3C31              ; if 1 + T falls outside the range SQRT(1/2) to SQRT(2) then
1679 3C31              ; just go to the code for LOG2(S) below.  Else use LOGAPPROX
1680 3C31              ; on T itself, IGNORING the sum 1 + T.
1681 3C31              ;
1682 3C31                       EXPORT LOG12R 
1683 3C31              LOG12R                                  ;       
1684 3C31              ;
1685 3C31              ; First compute 1 + T, saving the input T in cell W.
1686 3C31              ;
1687 3C31 20 5D 3C              JSR   KLUGE42
1688 3C34 20 18 39              JSR   KLUGE96                  ; Dest := 1 + T
1689 3C37              ;
1690 3C37              ; Now compare with bounds SQRT(1/2) and SQRT(2).
1691 3C37              ;
1692 3C37 A2 00                 LDX   #F_DEST
1693 3C39 A0 2A                 LDY   #F_FPKSQTHALF
1694 3C3B 20 50 3B              JSR   KLUGE28
1695 3C3E 30 32 F0 30           FBULE LOG2R
1696 3C44 A2 26                 LDX   #F_FPKSQRT2
1697 3C46 A0 00                 LDY   #F_DEST
1698 3C48 20 50 3B              JSR   KLUGE28
1699 3C4B 30 25 F0 23           FBLE LOG2R
1700 3C4F              ;
1701 3C4F              ; Input T is within the required range so restore input value and
1702 3C4F              ; just LOGAPPROX and finish up.
1703 3C4F              ;
1704 3C4F 20 58 3C              JSR   KLUGE40
1705 3C52 20 D2 3C              JSR   LOGAPPROX
1706 3C55 4C AD 3C              JMP   LOGFINI
1707 3C58                       EXPORT KLUGE40 
1708 3C58              KLUGE40                                 ;       
1709 3C58 A2 0C                 LDX   #F_W
1710 3C5A 4C A9 3A              JMP   KLUGE8
1711 3C5D                       EXPORT KLUGE42 
1712 3C5D              KLUGE42                                 ;       
1713 3C5D A2 00                 LDX   #F_DEST
1714 3C5F                       EXPORT KLUGE41 
1715 3C5F              KLUGE41                                 ;       
1716 3C5F A0 0C                 LDY   #F_W
1717 3C61 4C AB 3A              JMP   MOVEIT
1718 3C64                       EXPORT KLUGE49 
1719 3C64              KLUGE49                                 ;       
1720 3C64 A2 00                 LDX   #F_DEST
1721 3C66                       EXPORT KLUGE50 
1722 3C66              KLUGE50                                 ;       
1723 3C66 A0 0E                 LDY   #F_X
1724 3C68 4C AB 3A              JMP   MOVEIT
1725 3C6B                       EXPORT KLUGE51 
1726 3C6B              KLUGE51                                 ;       
1727 3C6B A2 00                 LDX   #F_DEST
1728 3C6D                       EXPORT KLUGE52 
1729 3C6D              KLUGE52                                 ;       
1730 3C6D A0 10                 LDY   #F_Y
1731 3C6F 4C AB 3A              JMP   MOVEIT
1732 3C72              ;
1733 3C72              ; Compute LOG2(T) for some positive, finite T.
1734 3C72              ; Represent T as 2^L * Q for SQRT (1/2) <= Q <= SQRT(2).
1735 3C72              ; Then LOG2(T) is L + LOG2(Q).
1736 3C72              ; LOG2(Q) for that restricted range is computed at LOGAPPROX below.
1737 3C72              ;
1738 3C72                       EXPORT LOG2R 
1739 3C72              LOG2R                                   ;       
1740 3C72              ;
1741 3C72              ; Compute LOGB(T), i.e., L, in W.
1742 3C72              ;
1743 3C72 20 5D 3C              JSR   KLUGE42
1744 3C75 A2 0C                 LDX   #F_W
1745 3C77 A0 1A                 LDY   #FOLOGB
1746 3C79 20 59 39              JSR   CALL1_SANE
1747 3C7C              ;
1748 3C7C              ; Then scale T down to range 1 to 2.  Use custom scale function with a
1749 3C7C              ; floating number as the second argument.
1750 3C7C              ;
1751 3C7C A2 0C                 LDX   #F_W
1752 3C7E 20 CE 3E              JSR   KLUGE67                  ; -L in W
1753 3C81 20 F8 3D              JSR   KLUGE36
1754 3C84 A2 0C                 LDX   #F_W
1755 3C86 20 CE 3E              JSR   KLUGE67                  ; Back to L in W
1756 3C89              ;
1757 3C89              ; If scaled value exceeds SQRT(2), then halve T and increment L.
1758 3C89              ;
1759 3C89 A2 00                 LDX   #F_DEST
1760 3C8B A0 26                 LDY   #F_FPKSQRT2
1761 3C8D 20 50 3B              JSR   KLUGE28
1762 3C90 30 0E F0 0C           FBULE z7s01
1763 3C96 A2 1C                 LDX   #F_FPK1
1764 3C98 A0 0C                 LDY   #F_W
1765 3C9A 20 1C 39              JSR   KLUGE98                  ; Increment L by 1
1766 3C9D 20 BB 3C              JSR   DOSCALE                  ; scale by -1 = T/2
1767 3CA0              ;
1768 3CA0              ; Now must subtract 1 from DEST in order to use LOGAPPROX,
1769 3CA0              ; which approximates LOG2(1 + S).
1770 3CA0              ;
1771 3CA0 A2 1C        Z7S01    LDX   #F_FPK1
1772 3CA2 20 71 3D              JSR   KLUGE90
1773 3CA5 20 D2 3C              JSR   LOGAPPROX
1774 3CA8              ;
1775 3CA8              ; Add L in.  Exit via check to see whether to multiply by LN(2).
1776 3CA8              ;
1777 3CA8 A2 0C                 LDX   #F_W
1778 3CAA 20 1A 39              JSR   KLUGE97
1779 3CAD              ; Finish up with a multiply by LN(2) if a natural log was requested.
1780 3CAD              ;
1781 3CAD                       EXPORT LOGFINI 
1782 3CAD              LOGFINI                                 ;       
1783 3CAD A9 01                 LDA   #BTLOGBASE2
1784 3CAF 24 62                 BIT   <OPCODE
1785 3CB1 D0 05                 BNE   z8s01
1786 3CB3 A2 38                 LDX   #F_FPKLOGE2
1787 3CB5 20 FA 38              JSR   KLUGE20
1788 3CB8 4C 9C 3B     Z8S01    JMP   RESULTDELIVERED
1789 3CBB              ;
1790 3CBB                       EXPORT DOSCALE 
1791 3CBB              DOSCALE                                 ;       
1792 3CBB                       LONGA ON
1793 3CBB                       LONGI ON
1794 3CBB C2 30                 REP   #$30
1795 3CBD 0B                    PHD                            ; save settings of D and B
1796 3CBE 8B                    PHB   
1797 3CBF A9 FF FF              LDA   #$FFFF                   ; push -1 scale factor
1798 3CC2 48                    PHA   
1799 3CC3 F4 00 00              PEA   0                        ; push dest address
1800 3CC6 18                    CLC   
1801 3CC7 7B                    TDC   
1802 3CC8 69 82 00              ADC   #<DEST
1803 3CCB 48                    PHA   
1804 3CCC A9 18 00              LDA   #FOSCALB                 ; full word
1805 3CCF 4C 38 39              JMP   KLUGE2
1806 3CD2                       LONGA OFF
1807 3CD2                       LONGI OFF
1808 3CD2              ;
1809 3CD2              ; Compute LOG2(1+S) for S between SQRT(1/2) and SQRT(2).
1810 3CD2              ; Assume all special cases have been filtered out and that
1811 3CD2              ; number DEST is indeed within range.
1812 3CD2              ; Let R := S / (2 + S).
1813 3CD2              ; Then LOGAPPROX := R * P(R*R) / Q(R*R),
1814 3CD2              ; where the coefficients are taken from LOG21P and LOG21Q.
1815 3CD2              ;
1816 3CD2              ; Leave cell W alone, for use by LOG2R.
1817 3CD2              ; Use cell Y_TEMP for R, X_TEMP for R*R.
1818 3CD2              ; Use DEST for R * P(R*R);  then Y_TEMP for Q(R*R).
1819 3CD2              ; Registers A0TEMP-A2TEMP are used by the POLYEVAL.
1820 3CD2              ;
1821 3CD2              ; To avoid spurious inexact, filter out 0.
1822 3CD2              ; To keep accuracy, filter out denorms.
1823 3CD2                       EXPORT LOGAPPROX 
1824 3CD2              LOGAPPROX                               ;       
1825 3CD2 20 C5 3E              JSR   KLUGE61
1826 3CD5 E0 FF                 CPX   #FCZERO                  ; Zero?
1827 3CD7 D0 01                 BNE   LANONZERO                ; Quit exit if zero
1828 3CD9 60                    RTS   
1829 3CDA                       EXPORT LANONZERO 
1830 3CDA              LANONZERO                               ;       
1831 3CDA E0 00                 CPX   #FCNORM
1832 3CDC F0 05                 BEQ   LANORMAL                 ; 0-norm, 1-denorm
1833 3CDE              ;
1834 3CDE              ; Since log2(1 + tiny) = ln (1 + tiny)/ ln(2) and ln (1 + tiny) is tiny + ...
1835 3CDE              ; just divide denorm by ln(2) and return.  Share exit code with main
1836 3CDE              ; computation.
1837 3CDE              ;
1838 3CDE A2 38                 LDX   #F_FPKLOGE2
1839 3CE0 4C 16 3D              JMP   LAFINI
1840 3CE3                       EXPORT LANORMAL 
1841 3CE3              LANORMAL                                ;       
1842 3CE3 20 64 3C              JSR   KLUGE49
1843 3CE6 A2 20                 LDX   #F_FPK2
1844 3CE8 20 1A 39              JSR   KLUGE97
1845 3CEB A2 00                 LDX   #F_DEST
1846 3CED A0 0E                 LDY   #F_X
1847 3CEF 20 02 3F              JSR   KLUGE93
1848 3CF2 A2 0E                 LDX   #F_X                     ; Y := R
1849 3CF4 A0 10                 LDY   #F_Y
1850 3CF6 20 AB 3A              JSR   MOVEIT
1851 3CF9 A2 0E                 LDX   #F_X
1852 3CFB 20 02 39              JSR   KLUGE21
1853 3CFE              ;
1854 3CFE              ; Evaluate P (R*R) into DEST
1855 3CFE              ;
1856 3CFE A2 00                 LDX   #F_DEST                  ; Result into DEST
1857 3D00 A0 14                 LDY   #F_LOG21P                ; Coefficients of P
1858 3D02 20 C4 39              JSR   KLUGE29
1859 3D05              ;
1860 3D05              ; Evaluate R * P (R*R) into DEST
1861 3D05              ;
1862 3D05 A2 10                 LDX   #F_Y                     ; R
1863 3D07 20 FA 38              JSR   KLUGE20
1864 3D0A              ;
1865 3D0A              ; Evaluate Q (R*R) into Y
1866 3D0A              ;
1867 3D0A A2 10                 LDX   #F_Y                     ; Result into Y
1868 3D0C A0 16                 LDY   #F_LOG21Q                ; Coefficients of Q
1869 3D0E 20 C4 39              JSR   KLUGE29
1870 3D11              ;
1871 3D11              ; Be sure inexact is set and clear all underflows up to the last step
1872 3D11              ; Finally, divide (R * (P (R*R)) in DEST by Q (R*R) in Y
1873 3D11              ;
1874 3D11 20 40 3A              JSR   CLEARUFLOW
1875 3D14 A2 10                 LDX   #F_Y                     ; Q (R * R)
1876 3D16                       EXPORT LAFINI 
1877 3D16              LAFINI                                  ;       
1878 3D16 20 00 3F              JSR   KLUGE92
1879 3D19 4C 82 3A              JMP   FORCEINEXACT
1880 3D1C                       ENDP 
1881 3D1C              ;
1882 3D1C              ; END OF FILE
1883 3D1C              ;
1884 3D1C              ; Exp, X^I
1885 3D1C              ;                  COPY           elems/ELEM2.O
1886 3D1C              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
1887 3D1C              ;; File:  Elem2.o                                                        ;
1888 3D1C              ;; For building 65816 Elems V0.0                                         ;
1889 3D1C              ;; Status: First attempt                                                 ;
1890 3D1C              ;; Copyright Apple Computer, Inc., 1983-1986                             ;
1891 3D1C              ;; All Rights Reserved                                                   ;
1892 3D1C              ;;                                                                       ;
1893 3D1C              ;; Written by C. Hausmann, 1983                                          ;
1894 3D1C              ;;                                                                       ;
1895 3D1C              ;; Modification History:                                                 ;
1896 3D1C              ;;      24Mar86 CRL     Rewritten for 65816                              ;
1897 3D1C              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
1898 3D1C              ;
1899 3D1C              ; EXP(x) and EXP2(x) share the same exception code.  To compute
1900 3D1C              ; numerical results, express resultas 2^K * ((2^frac - 1) + 1),
1901 3D1C              ; and use EXAPPROX to figure (2^frac - 1).
1902 3D1C              ;
1903 3D1C                       EXPORT EXPTOP 
1904 3D1C              EXPTOP   PROC 
1905 3D1C                       LONGA OFF
1906 3D1C                       LONGI OFF
1907 3D1C A5 6C                 LDA   <SRC2_CLASS
1908 3D1E 10 11                 BPL   EXPNONZERO               ; Handle positive non-zero case
1909 3D20 C9 FF                 CMP   #FCZERO
1910 3D22 F0 07                 BEQ   z1s05                    ; Handle zero case
1911 3D24 A5 6D                 LDA   <SRC2_SIGN               ; 0=positive, 80 (hex) =negative
1912 3D26 30 06                 BMI   z1s01
1913 3D28 4C 9C 3B              JMP   RESULTDELIVERED          ; Already have +INF in DEST
1914 3D2B 4C 5D 3B     Z1S05    JMP   P1STUFF                  ; EXP (+-0) is +1
1915 3D2E 4C 55 3B     Z1S01    JMP   POSTUFF                  ; EXP (-INF) is +0
1916 3D31                       EXPORT EXPNONZERO 
1917 3D31              EXPNONZERO                              ;       
1918 3D31 A9 01                 LDA   #BTLOGBASE2
1919 3D33 24 62                 BIT   <OPCODE                  ; Nonzero if EXP2X
1920 3D35 F0 06                 BEQ   EXPR
1921 3D37              ;
1922 3D37              ; 2^T is easy, for general T.
1923 3D37              ; Set cell W to integer part of T.
1924 3D37              ; Set T to fraction part of itself.
1925 3D37              ; User root computation to evaluate 2^T - 1 with LOGAPPROX;
1926 3D37              ; add 1 to T, and scale by W.
1927 3D37              ;
1928 3D37                       EXPORT EXP2R 
1929 3D37              EXP2R                                   ;       
1930 3D37 20 66 3D              JSR   SPLIT2
1931 3D3A 4C 5D 3D              JMP   EXPROOT                  ; and exit...
1932 3D3D              ;
1933 3D3D              ; EXP(T) is just slightly more complicated than EXP2(T) above.
1934 3D3D              ; Let T = K * LN(2) + F
1935 3D3D              ; Then EXP(T) is 2^K + ((2^F/LN(2)) - 1) + 1).
1936 3D3D              ; So user EXP2ROOT with W set to K and T set to F/LN(2).
1937 3D3D              ; Find F with REM modulo LN(2); then subtract from T and divide by LN(2)
1938 3D3D              ; to get K.
1939 3D3D                       EXPORT EXPR 
1940 3D3D              EXPR                                    ;       
1941 3D3D 20 78 3D              JSR   SPLIT
1942 3D40 20 8E 3A              JSR   TESTOFLOW
1943 3D43 F0 18                 BEQ   EXPROOT                  ; This may change depending
1944 3D45              ;                                       ; on how FTESTXCP is handled
1945 3D45 20 4E 3D              JSR   KLUGE17
1946 3D48 20 76 3A              JSR   FORCEUFLOW
1947 3D4B 4C 55 3B              JMP   POSTUFF
1948 3D4E                       EXPORT KLUGE17 
1949 3D4E              KLUGE17                                 ;       
1950 3D4E 20 82 3A              JSR   FORCEINEXACT             ; Either O/UFLOW
1951 3D51 A5 6D                 LDA   <SRC2_SIGN               ; 0=positive,80=negative
1952 3D53 30 05                 BMI   z2s01
1953 3D55 68                    PLA   
1954 3D56 68                    PLA   
1955 3D57 4C 68 3B              JMP   PINFSTUFF                ; Oflow to +INF
1956 3D5A 4C 44 3A     Z2S01    JMP   CLEAROFLOW
1957 3D5D              ;
1958 3D5D              ; This is the root of V^X where V is 2 or E.
1959 3D5D              ; Compute  ((2^T - 1) + 1) * 2 * W.  EXAPPROX gives the innermost
1960 3D5D              ; expression.  W is presumed to be an integer, possibly huge.
1961 3D5D              ;
1962 3D5D                       EXPORT EXPROOT 
1963 3D5D              EXPROOT                                 ;       
1964 3D5D 20 15 3E              JSR   EXAPPROX                 ; DEST <-- 2^T - 1
1965 3D60 20 F5 3D              JSR   KLUGE3
1966 3D63 4C 9C 3B              JMP   RESULTDELIVERED
1967 3D66              ;
1968 3D66              ; Given general number in T, split into integer part in W
1969 3D66              ; and fraction in T, rounding.
1970 3D66              ;
1971 3D66                       EXPORT SPLIT2 
1972 3D66              SPLIT2                                  ;       
1973 3D66 20 5D 3C              JSR   KLUGE42
1974 3D69 20 D8 3E              JSR   KLUGE64
1975 3D6C 20 4C 3A              JSR   CLRINEXACT               ; Dont' record rounding error
1976 3D6F A2 0C                 LDX   #F_W                     ; Integer part
1977 3D71                       EXPORT KLUGE90 
1978 3D71              KLUGE90                                 ;       
1979 3D71 A0 00                 LDY   #F_DEST                  ; All of number
1980 3D73                       EXPORT KLUGE91 
1981 3D73              KLUGE91                                 ;       
1982 3D73 A9 02                 LDA   #FOSUB
1983 3D75 4C 1E 39              JMP   CALL_SANE
1984 3D78              ;
1985 3D78              ; Split T for EXP(x) and EXP(x) - 1.
1986 3D78              ; Let T = K * LN(2) + F.  Want W=K and T=F/LN(2).
1987 3D78              ; Find F with REM modulo LN(2); then subtract from T and divide by LN(2)
1988 3D78              ; to get K.
1989 3D78                       EXPORT SPLIT 
1990 3D78              SPLIT                                   ;       
1991 3D78 20 5D 3C              JSR   KLUGE42
1992 3D7B A2 38                 LDX   #F_FPKLOGE2
1993 3D7D 20 12 39              JSR   KLUGE99
1994 3D80 A2 00                 LDX   #F_DEST
1995 3D82 A0 0C                 LDY   #F_W
1996 3D84 20 73 3D              JSR   KLUGE91                  ; T - (T REM LN(2)) in W
1997 3D87 A2 38                 LDX   #F_FPKLOGE2
1998 3D89 A0 0C                 LDY   #F_W
1999 3D8B 20 02 3F              JSR   KLUGE93
2000 3D8E 20 D8 3E              JSR   KLUGE64
2001 3D91 A2 38                 LDX   #F_FPKLOGE2
2002 3D93 20 00 3F              JSR   KLUGE92
2003 3D96 4C 4C 3A              JMP   CLRINEXACT               ; ... and exit
2004 3D99              ;
2005 3D99              ; EXP(x)-1 and EXP2(x)-1 share the same exception code.  Then both exploit
2006 3D99              ; EXAPPROX for the root computation  2^frac - 1.
2007 3D99              ;
2008 3D99                       EXPORT EXP1TOP 
2009 3D99              EXP1TOP                                 ;       
2010 3D99 A5 6C                 LDA   <SRC2_CLASS
2011 3D9B 10 0E                 BPL   EXP1FINITE               ; Handle finite non-zero case
2012 3D9D C9 FF                 CMP   #FCZERO
2013 3D9F F0 07                 BEQ   EXPEASY                  ; Handle zero case
2014 3DA1              ;                                       ; Y^+-0 - 1 is +-0
2015 3DA1 A5 6D                 LDA   <SRC2_SIGN               ; 0=positive, 1=negative
2016 3DA3 10 03                 BPL   EXPEASY
2017 3DA5 4C 61 3B              JMP   M1STUFF                  ;Y^-INF - 1 is -1
2018 3DA8                       EXPORT EXPEASY 
2019 3DA8              EXPEASY                                 ;       
2020 3DA8 4C 9C 3B              JMP   RESULTDELIVERED          ; Y^+INF - 1 is +INF
2021 3DAB                       EXPORT EXP1FINITE 
2022 3DAB              EXP1FINITE                              ;       
2023 3DAB              ;
2024 3DAB              ; If the number is denormalized, have easy case whether EXP1 or EXP21.
2025 3DAB              ;
2026 3DAB A9 01                 LDA   #BTLOGBASE2
2027 3DAD 24 62                 BIT   <OPCODE                  ; Nonzero if EXP2X
2028 3DAF F0 18                 BEQ   EXP1R
2029 3DB1              ;
2030 3DB1              ; As above, for 2^T-1 split T into fraction part in T and integer
2031 3DB1              ; in W, and got to root computation.
2032 3DB1              ;
2033 3DB1                       EXPORT EXP21R 
2034 3DB1              EXP21R                                  ;       
2035 3DB1 A5 6C                 LDA   <SRC2_CLASS
2036 3DB3 F0 0E                 BEQ   EXP21RNORM               ; Handle normal
2037 3DB5 A2 38                 LDX   #F_FPKLOGE2
2038 3DB7 20 FA 38              JSR   KLUGE20
2039 3DBA                       EXPORT EXP1OUT 
2040 3DBA              EXP1OUT                                 ;       
2041 3DBA 20 76 3A              JSR   FORCEUFLOW
2042 3DBD 20 82 3A              JSR   FORCEINEXACT
2043 3DC0 4C F2 3D              JMP   EXP1RDONE
2044 3DC3                       EXPORT EXP21RNORM 
2045 3DC3              EXP21RNORM                              ;       
2046 3DC3 20 66 3D              JSR   SPLIT2
2047 3DC6 4C DB 3D              JMP   EXP1ROOT
2048 3DC9              ;
2049 3DC9              ; For E^T-1, split T into K and F/LN(2), where T = K*LN(2) + F.
2050 3DC9              ; If overflow, then force INF or -1...
2051 3DC9              ;
2052 3DC9                       EXPORT EXP1R 
2053 3DC9              EXP1R                                   ;       
2054 3DC9 A5 6C                 LDA   <SRC2_CLASS              ; 0-norm, 1-denorm
2055 3DCB D0 ED                 BNE   EXP1OUT                  ; Handle denorm
2056 3DCD              ;                                       ; E^T-1 is T, with UFLOW
2057 3DCD              ;                                       ; for now.
2058 3DCD 20 78 3D              JSR   SPLIT
2059 3DD0 20 8E 3A              JSR   TESTOFLOW
2060 3DD3 F0 06                 BEQ   EXP1ROOT
2061 3DD5 20 4E 3D              JSR   KLUGE17
2062 3DD8 4C 61 3B              JMP   M1STUFF                  ; Force -1
2063 3DDB              ;
2064 3DDB              ; This is the root of V^X-1 where V is 2 or E.
2065 3DDB              ; Compute (2^T - 1) for fraction T.  Then if (integer) W is
2066 3DDB              ; nonzero, finish off with (((2^T - 1) + 1) * 2^W) - 1.
2067 3DDB              ;
2068 3DDB                       EXPORT EXP1ROOT 
2069 3DDB              EXP1ROOT                                ;       
2070 3DDB 20 15 3E              JSR   EXAPPROX                 ; 2^T - 1
2071 3DDE A2 0C                 LDX   #F_W
2072 3DE0 A0 3A                 LDY   #F_FPK0
2073 3DE2 20 50 3B              JSR   KLUGE28
2074 3DE5 F0 0B                 FBEQ EXP1RDONE
2075 3DE7 20 F5 3D              JSR   KLUGE3
2076 3DEA A2 1C                 LDX   #F_FPK1                  ; Finally, subtract 1
2077 3DEC 20 71 3D              JSR   KLUGE90
2078 3DEF              ;
2079 3DEF              ; Reset underflow, which cannot occur if W (as in 2^W) is nonzero.
2080 3DEF              ;
2081 3DEF 20 40 3A              JSR   CLEARUFLOW
2082 3DF2                       EXPORT EXP1RDONE 
2083 3DF2              EXP1RDONE                               ;       
2084 3DF2 4C 9C 3B              JMP   RESULTDELIVERED
2085 3DF5                       EXPORT KLUGE3 
2086 3DF5              KLUGE3                                  ;       
2087 3DF5 20 18 39              JSR   KLUGE96
2088 3DF8                       EXPORT KLUGE36 
2089 3DF8              KLUGE36                                 ;       
2090 3DF8 C2 30 18 7B           MOVECA <DEST,<A0_ADDR          ; Result Ptr
2091 3E05 C2 30 18 7B           MOVECA <W_TEMP,<OP1_ADDR       ; Integer part
2092 3E12 4C DC 3A              JMP   SCALBXX                  ; ((2^T - 1) + 1) * 2^W
2093 3E15              ;
2094 3E15              ; Compute approximate (2^T) - 1) for T in DEST.
2095 3E15              ; Uses cells X,Y (extended) and temporary ptrs A0_ADDR, OP1_ADDR.
2096 3E15              ; Expression has the form
2097 3E15              ;      ( 2 * T * P(T*T)) / (Q(T*T) - (T * P(T*T)) ).
2098 3E15              ; One special case: if T is 0, just return 0, and don't set
2099 3E15              ; the inexact flag.
2100 3E15              ;
2101 3E15                       EXPORT EXAPPROX 
2102 3E15              EXAPPROX                                ;       
2103 3E15 A2 00                 LDX   #F_DEST
2104 3E17 A0 3A                 LDY   #F_FPK0                  ; Compare input with 0
2105 3E19 20 50 3B              JSR   KLUGE28
2106 3E1C 30 05 70 03           FBNE EXPHARD
2107 3E22 60                    RTS   
2108 3E23                       EXPORT EXPHARD 
2109 3E23              EXPHARD                                 ;       
2110 3E23 20 6B 3C              JSR   KLUGE51
2111 3E26 A2 10                 LDX   #F_Y
2112 3E28 A0 10                 LDY   #F_Y
2113 3E2A 20 FC 38              JSR   KLUGE25
2114 3E2D A0 18                 LDY   #F_EXP21P                ; Exponent P coefs
2115 3E2F 20 C8 39              JSR   KLUGE32
2116 3E32 20 F8 38              JSR   KLUGE19
2117 3E35 A0 1A                 LDY   #F_EXP21Q
2118 3E37 20 C8 39              JSR   KLUGE32
2119 3E3A A2 00                 LDX   #F_DEST
2120 3E3C A0 0E                 LDY   #F_X
2121 3E3E 20 73 3D              JSR   KLUGE91
2122 3E41 A2 20                 LDX   #F_FPK2                  ; 2.0
2123 3E43 20 FA 38              JSR   KLUGE20
2124 3E46 A2 0E                 LDX   #F_X
2125 3E48 20 00 3F              JSR   KLUGE92
2126 3E4B              ;
2127 3E4B              ; Finally, set inexact and clear any underflow messages.
2128 3E4B              ;
2129 3E4B 20 82 3A              JSR   FORCEINEXACT
2130 3E4E 4C 40 3A              JMP   CLEARUFLOW               ; ...and exit.
2131 3E51                       ENDP 
2132 3E51              ;
2133 3E51              ;
2134 3E51              ;
2135 3E51              ;
2136 3E51              ; Raise extended dst to integer src power.
2137 3E51              ;
2138 3E51                       EXPORT KLUGE37 
2139 3E51              KLUGE37  PROC 
2140 3E51                       LONGA OFF
2141 3E51                       LONGI OFF
2142 3E51 A5 70 85 C5           MOVE2 <I_SRC,<J_TEMP
2143 3E59 60                    RTS   
2144 3E5A                       EXPORT XPWRITOP 
2145 3E5A              XPWRITOP                                ;       
2146 3E5A A5 70                 LDA   <I_SRC
2147 3E5C 05 71                 ORA   <I_SRC+1                 ; See if = 0
2148 3E5E D0 03                 BNE   z3s05
2149 3E60 4C 5D 3B              JMP   P1STUFF                  ; Any^0 is 1
2150 3E63 A5 6C        Z3S05    LDA   <SRC2_CLASS
2151 3E65 10 2F                 BPL   FINPWRI                  ; Nonzero^I
2152 3E67              ; Get here if INF^I of 0^I.  If I is negative, must reciprocate
2153 3E67              ; (signaling div by 0 in case of 0^-N).  If I is even, must clear
2154 3E67              ; sign.
2155 3E67              ;
2156 3E67 20 51 3E              JSR   KLUGE37
2157 3E6A 46 C6                 LSR   <J_TEMP+1                ; Get odd bit of I into C
2158 3E6C 66 C5                 ROR   <J_TEMP
2159 3E6E B0 03                 BCS   z3s01                    ; Carry bit set if odd
2160 3E70 20 D2 3E              JSR   KLUGE63
2161 3E73 A5 71        Z3S01    LDA   <I_SRC+1
2162 3E75 30 03                 BMI   z3s02
2163 3E77 4C 9C 3B              JMP   RESULTDELIVERED          ; (INF or ZERO)^POS
2164 3E7A A5 6C        Z3S02    LDA   <SRC2_CLASS
2165 3E7C C9 FF                 CMP   #FCZERO
2166 3E7E F0 0B                 BEQ   ZPWRNEG                  ; INF or ZERO?
2167 3E80 20 C5 3E              JSR   KLUGE61
2168 3E83 30 03                 BMI   Z3S03
2169 3E85 4C 55 3B              JMP   POSTUFF                  ; +INF^NEG is +0
2170 3E88 4C 59 3B     Z3S03    JMP   MOSTUFF                  ; -INF^NEG is -0
2171 3E8B                       EXPORT ZPWRNEG 
2172 3E8B              ZPWRNEG                                 ;       
2173 3E8B 20 C5 3E              JSR   KLUGE61
2174 3E8E 30 03                 BMI   z4s04
2175 3E90 4C 65 3B              JMP   DIVPOSTUFF               ; +0^NEG is +INF
2176 3E93 4C 6C 3B     Z4S04    JMP   DIVMOSTUFF               ; -0^NEG is -INF
2177 3E96              ;
2178 3E96              ; NONZERO^I is broken into two cases:
2179 3E96              ;   If I is small, then just multiply out.  Note that sign perseveres if
2180 3E96              ;   I is odd.
2181 3E96              ;   Otherwise, convert I to extended and evaluate with exponentials.
2182 3E96              ;
2183 3E96              ; 6502 NOTE:  Since 'SMALLEXP' = 255, only need to look at the high byte
2184 3E96              ; to see if a number is smaller than that.  Also, once I decide to use
2185 3E96              ; XPWRK algorithm, I will be working with a one byte quantity (for k).
2186 3E96              ;
2187 3E96                       EXPORT FINPWRI 
2188 3E96              FINPWRI                                 ;       
2189 3E96 20 1A 40              JSR   KLUGE4
2190 3E99 A5 F3                 LDA   <D0_TEMP+1
2191 3E9B D0 06                 BNE   XPWRBIG                  ; Use LOG and EXP
2192 3E9D 20 DE 3E              JSR   XPWRK                    ; Multiply out
2193 3EA0 4C 9C 3B              JMP   RESULTDELIVERED
2194 3EA3              ;
2195 3EA3              ; Integer power is too large to multiply out, so convert to extended
2196 3EA3              ; and use general x^y routine.  Make copy of integer in cell W.
2197 3EA3              ;
2198 3EA3                       EXPORT XPWRBIG 
2199 3EA3              XPWRBIG                                 ;       
2200 3EA3 20 C5 3E              JSR   KLUGE61
2201 3EA6 29 80                 AND   #$80                     ; show only sign bit
2202 3EA8 48                    PHA   
2203 3EA9 20 D2 3E              JSR   KLUGE63
2204 3EAC A2 06                 LDX   #F_ISRC                  ; Addr of Int
2205 3EAE A0 02                 LDY   #F_SRC
2206 3EB0 A9 0E                 LDA   #FOZ2X                   ; Convert int to ext
2207 3EB2 20 48 39              JSR   CALLI_SANE
2208 3EB5 20 36 3F              JSR   XPWRY                    ; Compute (DEST)^(SRC)
2209 3EB8              ;
2210 3EB8              ; Note that XPWRY mujst preserve the integer value in ISRC
2211 3EB8              ;
2212 3EB8 68                    PLA                            ; Retrieve sign of input
2213 3EB9 10 07                 BPL   z5s03                    ; If positive, don't care
2214 3EBB 46 70                 LSR   <I_SRC                   ; Low bit to carry
2215 3EBD 90 03                 BCC   z5s03                    ; Carry set if odd
2216 3EBF 20 CC 3E              JSR   KLUGE62
2217 3EC2 4C 9C 3B     Z5S03    JMP   RESULTDELIVERED
2218 3EC5                       EXPORT KLUGE61 
2219 3EC5              KLUGE61                                 ;       
2220 3EC5 A2 00                 LDX   #F_DEST
2221 3EC7 A0 1C                 LDY   #FOCLASS
2222 3EC9                       EXPORT KLUGE60 
2223 3EC9              KLUGE60                                 ;       
2224 3EC9 4C 59 39              JMP   CALL1_SANE
2225 3ECC                       EXPORT KLUGE62 
2226 3ECC              KLUGE62                                 ;       
2227 3ECC A2 00                 LDX   #F_DEST
2228 3ECE                       EXPORT KLUGE67 
2229 3ECE              KLUGE67                                 ;       
2230 3ECE A0 0D                 LDY   #FONEG
2231 3ED0 D0 F7                 BNE   KLUGE60
2232 3ED2                       EXPORT KLUGE63 
2233 3ED2              KLUGE63                                 ;       
2234 3ED2 A2 00                 LDX   #F_DEST
2235 3ED4                       EXPORT KLUGE68 
2236 3ED4              KLUGE68                                 ;       
2237 3ED4 A0 0F                 LDY   #FOABS
2238 3ED6 D0 F1                 BNE   KLUGE60
2239 3ED8                       EXPORT KLUGE64 
2240 3ED8              KLUGE64                                 ;       
2241 3ED8 A2 0C                 LDX   #F_W
2242 3EDA                       EXPORT KLUGE66 
2243 3EDA              KLUGE66                                 ;       
2244 3EDA A0 14                 LDY   #FORTI
2245 3EDC D0 EB                 BNE   KLUGE60
2246 3EDE                       ENDP 
2247 3EDE              ;
2248 3EDE              ; Raise T to the power ISRC, leaving the result in DEST_ADDR.  D0TEMP =
2249 3EDE              ; ABS (ISRC).  If ISRC is negative, evaluate the positive power and
2250 3EDE              ; reciprocate at the end.  Know ISRC is nonzero.  Sign of DEST_ADDR is
2251 3EDE              ; propagated correctly.  Trash A0_TEMP, A1_TEMP, D0_TEMP, I_TEMP, W_TEMP,
2252 3EDE              ; J_TEMP, X_TEMP.
2253 3EDE              ;
2254 3EDE                       EXPORT XPWRK 
2255 3EDE              XPWRK    PROC 
2256 3EDE                       LONGA OFF
2257 3EDE                       LONGI OFF
2258 3EDE 20 64 3C              JSR   KLUGE49
2259 3EE1 20 1B 3F              JSR   XPWRKLOOP
2260 3EE4              ;
2261 3EE4              ; Now that loop is finished, produce 1 * T^|I| or 1 / T^|I|, depending
2262 3EE4              ; on sign of I.  If overflow or underflow has occurred and I is negative,
2263 3EE4              ; redo compuation with pre-reciprocated T.
2264 3EE4              ;
2265 3EE4 A5 71                 LDA   <I_SRC+1                 ; Is I negative?
2266 3EE6 30 07                 BMI   XPWRKDIV
2267 3EE8                       EXPORT XPWRKSTORE 
2268 3EE8              XPWRKSTORE                              ;       
2269 3EE8 A2 0C                 LDX   #F_W                     ; T <-- T^|I|
2270 3EEA A0 00                 LDY   #F_DEST
2271 3EEC 4C 58 3C              JMP   KLUGE40
2272 3EEF                       EXPORT XPWRKDIV 
2273 3EEF              XPWRKDIV                                ;       
2274 3EEF A2 1C                 LDX   #F_FPK1                  ; T <-- 1
2275 3EF1 20 A9 3A              JSR   KLUGE8
2276 3EF4 20 8A 3A              JSR   TESTUFLOW
2277 3EF7 D0 0E                 BNE   XPWRKCLEAR
2278 3EF9 20 8E 3A              JSR   TESTOFLOW
2279 3EFC D0 09                 BNE   XPWRKCLEAR
2280 3EFE                       EXPORT KLUGE95 
2281 3EFE              KLUGE95                                 ;       
2282 3EFE A2 0C                 LDX   #F_W                     ; W = T^|I| from XPWRKLOOP
2283 3F00                       EXPORT KLUGE92 
2284 3F00              KLUGE92                                 ;       
2285 3F00 A0 00                 LDY   #F_DEST
2286 3F02                       EXPORT KLUGE93 
2287 3F02              KLUGE93                                 ;       
2288 3F02 A9 06                 LDA   #FODIV
2289 3F04 4C 1E 39              JMP   CALL_SANE
2290 3F07                       EXPORT XPWRKCLEAR 
2291 3F07              XPWRKCLEAR                              ;       
2292 3F07 20 44 3A              JSR   CLEAROFLOW
2293 3F0A 20 40 3A              JSR   CLEARUFLOW
2294 3F0D A2 0E                 LDX   #F_X                     ; Saved input T atop T^|I|
2295 3F0F 20 00 3F              JSR   KLUGE92
2296 3F12 20 1A 40              JSR   KLUGE4
2297 3F15 20 1B 3F              JSR   XPWRKLOOP
2298 3F18 4C E8 3E              JMP   XPWRKSTORE
2299 3F1B              ;
2300 3F1B              ; Input:   D0_TEMP = positive integer K  ( <255 )
2301 3F1B              ;          DEST_ADDR = X
2302 3F1B              ; Output:  W_TEMP = X^K
2303 3F1B              ; Trashes: D0_TEMP
2304 3F1B              ;
2305 3F1B                       EXPORT XPWRKLOOP 
2306 3F1B              XPWRKLOOP                               ;       
2307 3F1B A2 1C                 LDX   #F_FPK1                  ; See result with 1.0
2308 3F1D 20 5F 3C              JSR   KLUGE41
2309 3F20 4C 28 3F              JMP   XKLPENTRY
2310 3F23                       EXPORT XKLPTOP 
2311 3F23              XKLPTOP                                 ;       
2312 3F23 A2 00                 LDX   #F_DEST
2313 3F25 20 FA 38              JSR   KLUGE20
2314 3F28                       EXPORT XKLPENTRY 
2315 3F28              XKLPENTRY                               ;       
2316 3F28 46 F2                 LSR   <D0_TEMP                 ; Get low bit of k into C
2317 3F2A 90 05                 BCC   XKLPSKIP
2318 3F2C A2 00                 LDX   #F_DEST                  ; T^(2^I)
2319 3F2E 20 08 39              JSR   KLUGE24
2320 3F31                       EXPORT XKLPSKIP 
2321 3F31              XKLPSKIP                                ;       
2322 3F31 A5 F2                 LDA   <D0_TEMP                 ; Any more bits?
2323 3F33 D0 EE                 BNE   XKLPTOP
2324 3F35 60                    RTS   
2325 3F36              ;
2326 3F36              ; Simple routine to compute (DEST)^(SRC) into (DEST).
2327 3F36              ; Know that (DEST) is positive.  Know that the FMULX will never
2328 3F36              ; encounter 0 * INF, so extreme cases, like INF^3, will be handled
2329 3F36              ; correctly.
2330 3F36              ;
2331 3F36                       EXPORT XPWRY 
2332 3F36              XPWRY                                   ;       
2333 3F36 A2 00                 LDX   #F_DEST                  ; Copy Dest into temporary
2334 3F38              ;                                       ; accumulator
2335 3F38 20 4F 3F              JSR   KLUGE44
2336 3F3B A0 02                 LDY   #FOLOG2X                 ; LOG2(ACCUM)
2337 3F3D                       EXPORT KLUGE5 
2338 3F3D              KLUGE5                                  ;       
2339 3F3D 20 88 39              JSR   KLUGE30
2340 3F40 20 0C 39              JSR   KLUGE26                  ; SRC * LOG2 (ACCUM)
2341 3F43 A0 0A                 LDY   #FOEXP2X                 ; ACCUM^SRC
2342 3F45 20 88 39              JSR   KLUGE30
2343 3F48                       EXPORT KLUGE43 
2344 3F48              KLUGE43                                 ;       
2345 3F48 A2 62                 LDX   #F_ACCUM                 ; Move accum back into Dest
2346 3F4A 4C A9 3A              JMP   KLUGE8
2347 3F4D                       EXPORT KLUGE45 
2348 3F4D              KLUGE45                                 ;       
2349 3F4D A2 04                 LDX   #F_SRC2
2350 3F4F                       EXPORT KLUGE44 
2351 3F4F              KLUGE44                                 ;       
2352 3F4F A0 62                 LDY   #F_ACCUM
2353 3F51 4C AB 3A              JMP   MOVEIT
2354 3F54                       ENDP 
2355 3F54              ;
2356 3F54              ; END OF FILE
2357 3F54              ;
2358 3F54              ; X^Y, Compound, Annuity
2359 3F54              ;                  COPY           elems/ELEM3.O
2360 3F54              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
2361 3F54              ;; File:  Elem3.o                                                        ;
2362 3F54              ;; For building 65816 Elems V0.0                                         ;
2363 3F54              ;; Status: First attempt                                                 ;
2364 3F54              ;; Copyright Apple Computer, Inc., 1983-1986                             ;
2365 3F54              ;; All Rights Reserved                                                   ;
2366 3F54              ;;                                                                       ;
2367 3F54              ;; Written by C. Hausmann, 1983                                          ;
2368 3F54              ;;                                                                       ;
2369 3F54              ;; Modification History:                                                 ;
2370 3F54              ;;      24Mar86 CRL     Rewritten for 65816                              ;
2371 3F54              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
2372 3F54              ;
2373 3F54              ; General function x^y is beset by exceptional cases.
2374 3F54              ;
2375 3F54                       EXPORT XPWRYTOP 
2376 3F54              XPWRYTOP PROC 
2377 3F54                       LONGA OFF
2378 3F54                       LONGI OFF
2379 3F54 A5 6D                 LDA   <SRC2_SIGN               ; Is X=DEST negative?
2380 3F56 30 16                 BMI   NEGPWRY
2381 3F58 20 B3 3F              JSR   XPWRYCOM
2382 3F5B 4C 9C 3B              JMP   RESULTDELIVERED
2383 3F5E              ;
2384 3F5E              ; Signal X^Y error and stuff a NAN.  Special entry accommodates branches from
2385 3F5E              ; within subroutines, in which case a return address must be popped.
2386 3F5E              ;
2387 3F5E                       EXPORT XPWRY9ERR 
2388 3F5E              XPWRY9ERR                               ;       
2389 3F5E 68                    PLA                            ; pop extra return address
2390 3F5F 68                    PLA   
2391 3F60                       EXPORT XPWRYERR 
2392 3F60              XPWRYERR                                ;       
2393 3F60 20 4C 3A              JSR   CLRINEXACT               ; Signal invalid only
2394 3F63 A9 25                 LDA   #NANPOWER
2395 3F65                       EXPORT KLUGE38 
2396 3F65              KLUGE38                                 ;       
2397 3F65 85 6E                 STA   <CLASS_CODE
2398 3F67 A5 6B                 LDA   <SRC_SIGN                ; Check that D0 corresponds
2399 3F69              ;                                       ; to this!
2400 3F69 85 6F                 STA   <CLASS_SIGN
2401 3F6B 4C 77 3B              JMP   ERRORNAN
2402 3F6E              ;
2403 3F6E              ; If X is negative, check that Y is integral;  otherwise error.
2404 3F6E              ; Save parity of Y to fix sign at end of XPWRYCOM.
2405 3F6E              ;
2406 3F6E                       EXPORT NEGPWRY 
2407 3F6E              NEGPWRY                                 ;       
2408 3F6E A5 6A                 LDA   <SRC_CLASS
2409 3F70 C9 FE                 CMP   #FCINF
2410 3F72 F0 EC                 BEQ   XPWRYERR                 ; Y class - INF
2411 3F74 A2 02                 LDX   #F_SRC                   ; Y=SRC
2412 3F76 20 5F 3C              JSR   KLUGE41
2413 3F79 A2 02                 LDX   #F_SRC
2414 3F7B 20 DA 3E              JSR   KLUGE66
2415 3F7E A2 02                 LDX   #F_SRC
2416 3F80 20 DA 3E              JSR   KLUGE66
2417 3F83 20 9A 3A              JSR   TESTINEXACT
2418 3F86 D0 D8                 BNE   XPWRYERR
2419 3F88              ;
2420 3F88              ; NEG ^ INT requires that parity of Y be saved in cell J for later
2421 3F88              ; setting of sign. To find low bit of floating integer, divide by
2422 3F88              ; 2 and test inexact.
2423 3F88              ;
2424 3F88 A2 20                 LDX   #F_FPK2                  ; 2.0
2425 3F8A A0 0C                 LDY   #F_W
2426 3F8C 20 02 3F              JSR   KLUGE93
2427 3F8F 20 D8 3E              JSR   KLUGE64
2428 3F92
2429 3F92                       LONGA ON
2430 3F92                       LONGI ON
2431 3F92 C2 30                 REP   #$30                     ; save flags, first 16 bit mode
2432 3F94 A0 03 00              LDY   #FOGETENV                ; set all 16 bits
2433 3F97 20 83 39              JSR   CALL0_SANE               ; and place zero arg call
2434 3F9A                       LONGA OFF
2435 3F9A                       LONGI OFF
2436 3F9A 86 C3                 STX   <I_TEMP
2437 3F9C 84 C4                 STY   <I_TEMP+1
2438 3F9E 20 4C 3A              JSR   CLRINEXACT
2439 3FA1 20 D2 3E              JSR   KLUGE63
2440 3FA4 20 B3 3F              JSR   XPWRYCOM                 ; Abs (DEST) ^ (SRC)
2441 3FA7              ;
2442 3FA7              ; Fix sign of power, according to parity of Y.  The parity is stored in
2443 3FA7              ; the inexact flag, saved in cell I.  It's in the high byte so just do
2444 3FA7              ; a bit test.
2445 3FA7              ;
2446 3FA7 A9 10                 LDA   #FBINEXACT
2447 3FA9 24 C4                 BIT   <I_TEMP+1
2448 3FAB F0 03                 BEQ   z1s01                    ; Negate if odd (inexact)
2449 3FAD 20 CC 3E              JSR   KLUGE62
2450 3FB0 4C 9C 3B     Z1S01    JMP   RESULTDELIVERED
2451 3FB3              ;
2452 3FB3              ; Common routine to raise DEST to SRC power.
2453 3FB3              ; Know DEST >= 0 and SRC is not a NAN.
2454 3FB3              ; Have class codes in SRC2_CLASS and SRC_CLASS, respectively.
2455 3FB3              ; Can run through  2 ^ Y*LOG2(x)  code so long as won't multiply
2456 3FB3              ; INF and 0 to compute exponent.  As a minor detail, if Y is 0 or INF,
2457 3FB3              ; clear any inexact that may have been set by LOG2(x).
2458 3FB3              ;
2459 3FB3              ; Since this is called as a subroutine, exits to XPWRYERR must have a
2460 3FB3              ; special pop for the return address.
2461 3FB3              ;
2462 3FB3                       EXPORT XPWRYCOM 
2463 3FB3              XPWRYCOM                                ;       
2464 3FB3 A5 6C                 LDA   <SRC2_CLASS
2465 3FB5 C9 FF                 CMP   #FCZERO
2466 3FB7 D0 19                 BNE   NONPWRY
2467 3FB9              ;
2468 3FB9              ; 0 ^ some
2469 3FB9              ;
2470 3FB9 A5 6A                 LDA   <SRC_CLASS
2471 3FBB C9 FF                 CMP   #FCZERO
2472 3FBD D0 03                 BNE   z2s02
2473 3FBF 4C 5E 3F              JMP   XPWRY9ERR                ; 0^0 error, with
2474 3FC2              ;                                       ; rts pop
2475 3FC2 A5 6B        Z2S02    LDA   <SRC_SIGN                ; Sign of Y
2476 3FC4 10 07                 BPL   z2s01
2477 3FC6              ;
2478 3FC6              ; 0 ^ nonzero
2479 3FC6              ;
2480 3FC6 20 7A 3A              JSR   FORCEDIVZER              ; Signal div by zero
2481 3FC9 A2 3E                 LDX   #F_FPKINF                ; Stuff result and exit
2482 3FCB D0 02                 BNE   z2s03
2483 3FCD A2 3A        Z2S01    LDX   #F_FPK0
2484 3FCF 4C A9 3A     Z2S03    JMP   KLUGE8
2485 3FD2              ;
2486 3FD2              ; nonzero ^ some
2487 3FD2              ;
2488 3FD2                       EXPORT NONPWRY 
2489 3FD2              NONPWRY                                 ;       
2490 3FD2 10 09                 BPL   FINPWRY                  ; Exit if X finite
2491 3FD4              ;
2492 3FD4              ; inf ^ some
2493 3FD4              ;
2494 3FD4 A5 6A                 LDA   <SRC_CLASS
2495 3FD6 C9 FF                 CMP   #FCZERO
2496 3FD8 D0 19                 BNE   XPWRYOK                  ; Y = norm, denorm, or INF
2497 3FDA 4C 5E 3F              JMP   XPWRY9ERR                ; INF^0 is an error
2498 3FDD              ;
2499 3FDD              ; finite ^ some
2500 3FDD              ;
2501 3FDD                       EXPORT FINPWRY 
2502 3FDD              FINPWRY                                 ;       
2503 3FDD A5 6A                 LDA   <SRC_CLASS
2504 3FDF C9 FE                 CMP   #FCINF
2505 3FE1 D0 10                 BNE   XPWRYOK                  ; FIN ^ FIN is ok
2506 3FE3              ;
2507 3FE3              ; finite ^ inf has the special case 1^INF which is an error.
2508 3FE3              ;
2509 3FE3 A2 00                 LDX   #F_DEST
2510 3FE5 A0 1C                 LDY   #F_FPK1
2511 3FE7 20 50 3B              JSR   KLUGE28
2512 3FEA 30 07 70 05           FBNE XPWRYOK
2513 3FF0 4C 5E 3F              JMP   XPWRY9ERR
2514 3FF3              ;
2515 3FF3              ; Finally, compute finite^reasonable and return.
2516 3FF3              ; Two cases: if exponent is a small integer, then just multiply;
2517 3FF3              ; else use log and exp.  To check for an integer, try converting to
2518 3FF3              ; 16 bits.  Overflow is Invalid, rounding error is Inexact.
2519 3FF3              ; Must reset Invalid, but if Inexact the result will be anyway.
2520 3FF3              ;
2521 3FF3              ; 6502 NOTE: Unlike the MAC routine, it proves to be unnecessary to
2522 3FF3              ; save an extra copy of SRC_CLASS since it is never modified in
2523 3FF3              ; call to XPWRK (in the 6502 version).
2524 3FF3              ;
2525 3FF3                       EXPORT XPWRYOK 
2526 3FF3              XPWRYOK                                 ;       
2527 3FF3 A2 02                 LDX   #F_SRC                   ; Exponent address index
2528 3FF5 A0 06                 LDY   #F_ISRC
2529 3FF7 A9 10                 LDA   #FOX2Z                   ; Convert to integer
2530 3FF9 20 48 39              JSR   CALLI_SANE
2531 3FFC A9 11                 LDA   #FBIplusX                ; logical OR of i,x
2532 3FFE 85 64                 STA   <EXCPTION
2533 4000 A2 1B                 LDX   #FOTESTXCP
2534 4002 20 A4 3A              JSR   KLUGE31                  ; Either error?
2535 4005 F0 06                 BEQ   z3s01
2536 4007 20 48 3A              JSR   CLEARINVALID
2537 400A 4C 35 40              JMP   XPWRYHARD                ; Yes! So do it using log
2538 400D              ;                                       ; and exp
2539 400D 20 48 3A     Z3S01    JSR   CLEARINVALID             ; Clear undeserved error
2540 4010 20 1A 40              JSR   KLUGE4
2541 4013 A5 F3                 LDA   <D0_TEMP+1
2542 4015 D0 1E                 BNE   XPWRYHARD
2543 4017 4C DE 3E              JMP   XPWRK                    ; Do it as an integer and
2544 401A              ;                                       ; exit (k small)
2545 401A                       EXPORT KLUGE4 
2546 401A              KLUGE4                                  ;       
2547 401A A5 70 85 F2           MOVE2 <I_SRC,<D0_TEMP
2548 4022 A5 71                 LDA   <I_SRC+1
2549 4024 10 0E                 BPL   z4s02
2550 4026 20 51 3E              JSR   KLUGE37
2551 4029 20 CE 3A              JSR   NEGATE
2552 402C A5 C5 85 F2           MOVE2 <J_TEMP,<D0_TEMP
2553 4034 60           Z4S02    RTS   
2554 4035                       EXPORT XPWRYHARD 
2555 4035              XPWRYHARD                               ;       
2556 4035 20 4C 3A              JSR   CLRINEXACT
2557 4038 18                    CLC   
2558 4039 A5 6A                 LDA   <SRC_CLASS
2559 403B 20 36 3F              JSR   XPWRY
2560 403E A5 6A                 LDA   <SRC_CLASS
2561 4040 18                    CLC   
2562 4041 A5 6A                 LDA   <SRC_CLASS               ; Check for y = 0 or INF
2563 4043 10 03                 BPL   z5s01
2564 4045 4C 4C 3A              JMP   CLRINEXACT               ; and return from there
2565 4048 60           Z5S01    RTS   
2566 4049                       ENDP 
2567 4049              ;
2568 4049              ; Compute  DEST <-- (1 + SRC2)^SRC       r = SRC2    n = SRC
2569 4049              ; Watch for special cases:
2570 4049              ;          SRC2  < -1  is invalid
2571 4049              ;          else  SRC = 0 yields 1
2572 4049              ;          else  SRC2 = 0 and SRC = INF if invalid
2573 4049              ;          else  SRC = INF yields 0 or INF according to SRC2
2574 4049              ;          else  SRC2 = -1 yields 0, 1, or INF according to SRC
2575 4049              ;          else  actually compute (1 + r)^n !!
2576 4049              ;
2577 4049                       EXPORT COMPOUNDTOP 
2578 4049              COMPOUNDTOP PROC 
2579 4049                       LONGA OFF
2580 4049                       LONGI OFF
2581 4049 A2 04                 LDX   #F_SRC2
2582 404B A0 1E                 LDY   #F_FPKM1                 ; -1
2583 404D 20 50 3B              JSR   KLUGE28
2584 4050 F0 05                 FBEQ z6s01
2585 4052 70 16                 FBGT CMPGTM1
2586 4054 4C AE 40              JMP   ERRFINAN                 ; Unordered or less than -1
2587 4057              ;
2588 4057              ; Get here if SRC2 is -1.  Check SRC for 0 or nonzero.
2589 4057              ;
2590 4057 A5 6A        Z6S01    LDA   <SRC_CLASS
2591 4059 C9 FF                 CMP   #FCZERO
2592 405B D0 03                 BNE   CMPM1N
2593 405D                       EXPORT CMPTOZERO 
2594 405D              CMPTOZERO                               ;       
2595 405D 4C 5D 3B              JMP   P1STUFF                  ; (1 + some)^0 is +1
2596 4060                       EXPORT CMPM1N 
2597 4060              CMPM1N                                  ;       
2598 4060 A5 6B                 LDA   <SRC_SIGN
2599 4062 10 03                 BPL   CMPZERO
2600 4064 4C 65 3B              JMP   DIVPOSTUFF               ; (1 - 1)^NEG is +INF
2601 4067                       EXPORT CMPZERO 
2602 4067              CMPZERO                                 ;       
2603 4067 4C 55 3B              JMP   POSTUFF                  ; (1 - 1)^POS is +0
2604 406A              ;
2605 406A              ; Get here if SRC2 (r) is > -1.
2606 406A              ;
2607 406A                       EXPORT CMPGTM1 
2608 406A              CMPGTM1                                 ;       
2609 406A A5 6A                 LDA   <SRC_CLASS
2610 406C C9 FF                 CMP   #FCZERO
2611 406E F0 ED                 BEQ   CMPTOZERO                ; (1 + some)^0 is +1
2612 4070 10 12                 BPL   CMPTOFIN                 ; Go do (1 + some)^FINITE
2613 4072              ;
2614 4072              ; Get here if (1 + some)^INF.  Check for 1^INF, an error, else have
2615 4072              ; INF or 0 according to SRC and SRC2.
2616 4072              ;
2617 4072 A5 6C                 LDA   <SRC2_CLASS
2618 4074 C9 FF                 CMP   #FCZERO
2619 4076 D0 03                 BNE   z7s01
2620 4078 4C AE 40              JMP   ERRFINAN
2621 407B A5 6B        Z7S01    LDA   <SRC_SIGN
2622 407D 45 6D                 EOR   <SRC2_SIGN
2623 407F D0 E6                 BNE   CMPZERO                  ; Signs differ --> ZERO
2624 4081 4C 68 3B              JMP   PINFSTUFF                ; Signs same --> +INF
2625 4084              ;
2626 4084              ; Finally, compute (1 + reasonable)^finite with the usual...
2627 4084              ;
2628 4084                       EXPORT CMPTOFIN 
2629 4084              CMPTOFIN                                ;       
2630 4084 20 4D 3F              JSR   KLUGE45
2631 4087 A0 06                 LDY   #FOLOG21X                ; LOG2 (1 + ACCUM)
2632 4089 20 3D 3F              JSR   KLUGE5
2633 408C 20 44 3A              JSR   CLEAROFLOW
2634 408F 20 40 3A              JSR   CLEARUFLOW
2635 4092 20 9A 3A              JSR   TESTINEXACT
2636 4095 F0 14                 BEQ   z8s01                    ; Done if not inexact
2637 4097 20 C5 3E              JSR   KLUGE61
2638 409A E0 00                 CPX   #FCNORM                  ; Normal - done
2639 409C F0 0D                 BEQ   z8s01
2640 409E E0 FE                 CPX   #FCINF                   ; Infinite - set oflow
2641 40A0 D0 06                 BNE   z8s02
2642 40A2 20 72 3A              JSR   FORCEOFLOW
2643 40A5 4C 9C 3B              JMP   RESULTDELIVERED
2644 40A8 20 76 3A     Z8S02    JSR   FORCEUFLOW               ; Zero, denorm - set uflow
2645 40AB 4C 9C 3B     Z8S01    JMP   RESULTDELIVERED
2646 40AE              ;
2647 40AE              ; Routine to stuff the financial NAN and go.
2648 40AE              ;
2649 40AE                       EXPORT ERRFINAN 
2650 40AE              ERRFINAN                                ;       
2651 40AE A9 26                 LDA   #NANFINAN
2652 40B0 4C 65 3F              JMP   KLUGE38
2653 40B3                       ENDP 
2654 40B3              ;
2655 40B3              ; Compute annuity factor:
2656 40B3              ;     (1 - (1 + r)^-n ) / r
2657 40B3              ; for  r = SRC2  and  n = SRC.
2658 40B3              ; Multitudinous special cases handled piece by piece.
2659 40B3              ;
2660 40B3                       EXPORT ANNUITYTOP 
2661 40B3              ANNUITYTOP PROC 
2662 40B3                       LONGA OFF
2663 40B3                       LONGI OFF
2664 40B3 A2 04                 LDX   #F_SRC2                  ; R
2665 40B5 A0 1E                 LDY   #F_FPKM1                 ; -1
2666 40B7 20 50 3B              JSR   KLUGE28
2667 40BA 30 F2 70 02           FBULT ERRFINAN                 ; R < -1 is an error
2668 40C0 30 14 70 12           FBNE ANNOK
2669 40C6              ;
2670 40C6              ; Get here is have (1 - 1)^ANY.  Just check n = SRC.
2671 40C6              ;
2672 40C6 A5 6A                 LDA   <SRC_CLASS
2673 40C8 C9 FF                 CMP   #FCZERO
2674 40CA F0 10                 BEQ   ANNO                     ; ANN (-1, 0) is + 0
2675 40CC A5 6B                 LDA   <SRC_SIGN                ; Check sign of nonzero N
2676 40CE 30 03                 BMI   ANNM1
2677 40D0 4C 65 3B              JMP   DIVPOSTUFF
2678 40D3                       EXPORT ANNM1 
2679 40D3              ANNM1                                   ;       
2680 40D3 4C 61 3B              JMP   M1STUFF
2681 40D6              ;
2682 40D6              ; Know that R = SRC2 exceeds -1.  Check first for N=SRC=0.
2683 40D6              ;
2684 40D6                       EXPORT ANNOK 
2685 40D6              ANNOK                                   ;       
2686 40D6 A5 6A                 LDA   <SRC_CLASS
2687 40D8 C9 FF                 CMP   #FCZERO
2688 40DA D0 03                 BNE   ANNXN
2689 40DC                       EXPORT ANNO 
2690 40DC              ANNO                                    ;       
2691 40DC 4C 55 3B              JMP   POSTUFF
2692 40DF              ;
2693 40DF              ; Now check for unusual, 0 or INF, R=SRC2.
2694 40DF              ;
2695 40DF                       EXPORT ANNXN 
2696 40DF              ANNXN                                   ;       
2697 40DF A5 6C                 LDA   <SRC2_CLASS
2698 40E1 C9 FF                 CMP   #FCZERO
2699 40E3 F0 05                 BEQ   ANNSRC                   ; SRC2=0
2700 40E5 10 1D                 BPL   ANNROK                   ; Norm, Denorm
2701 40E7 4C EF 40              JMP   ANNRINF                  ; Infinity
2702 40EA              ;
2703 40EA              ; R = SRC2 = 0.  Limit gives result of N = SRC.
2704 40EA              ;
2705 40EA                       EXPORT ANNSRC 
2706 40EA              ANNSRC                                  ;       
2707 40EA A2 02                 LDX   #F_SRC
2708 40EC 4C 71 3B              JMP   KLUGE7
2709 40EF              ;
2710 40EF              ; R = SRC2 = +INF.  If N = SRC is nonnegative have 0, else test N=SRC vs -1.
2711 40EF              ;
2712 40EF                       EXPORT ANNRINF 
2713 40EF              ANNRINF                                 ;       
2714 40EF A5 6B                 LDA   <SRC_SIGN
2715 40F1 10 E9                 BPL   ANNO                     ; Force +0
2716 40F3 A2 02                 LDX   #F_SRC                   ; SRC
2717 40F5 A0 1E                 LDY   #F_FPKM1                 ; -1
2718 40F7 20 50 3B              JSR   KLUGE28
2719 40FA F0 D7                 FBEQ ANNM1                     ; N = -1, stuff -1
2720 40FC 30 03                 FBLT z9s01
2721 40FE 4C 59 3B              JMP   MOSTUFF
2722 4101 4C 6F 3B     Z9S01    JMP   MINFSTUFF
2723 4104              ;
2724 4104              ; Way down here, we have R=SRC2 a normal or denormal number.
2725 4104              ; Last check is for N=SRC=INF.
2726 4104              ;
2727 4104                       EXPORT ANNROK 
2728 4104              ANNROK                                  ;       
2729 4104 A5 6A                 LDA   <SRC_CLASS
2730 4106 10 17                 BPL   ANNDOIT                  ; Norm or Denorm
2731 4108 A5 6B                 LDA   <SRC_SIGN
2732 410A 45 6D                 EOR   <SRC2_SIGN               ; Do R and N signs match
2733 410C D0 DC                 BNE   ANNSRC
2734 410E A2 1C                 LDX   #F_FPK1                  ; X <-- +1
2735 4110 20 66 3C              JSR   KLUGE50
2736 4113 A2 04                 LDX   #F_SRC2                  ; Addr of R, divisor
2737 4115 A0 0E                 LDY   #F_X
2738 4117 20 02 3F              JSR   KLUGE93
2739 411A A2 0E                 LDX   #F_X                     ; Dest <-- 1/R
2740 411C 4C 71 3B              JMP   KLUGE7
2741 411F              ;
2742 411F              ; Finally, compute (1 - (1 + r)^-n ) / r.
2743 411F              ; Distinguish two cases:
2744 411F              ;      r normal:
2745 411F              ;               log2(1 + r)
2746 411F              ;               n * log2 (1 + r)
2747 411F              ;               -n * log2 (1 + r)
2748 411F              ;               2^(...) - 1
2749 411F              ;               1 - 2^(...)
2750 411F              ;               (1 - 2^(...)) / r
2751 411F              ;
2752 411F              ;      r denormal:
2753 411F              ;               log (1 + r) is about r
2754 411F              ;               n * r
2755 411F              ;               -n * r
2756 411F              ;               e^(...) - 1
2757 411F              ;               (1 - e^(...)) / r
2758 411F              ;
2759 411F                       EXPORT ANNDOIT 
2760 411F              ANNDOIT                                 ;       
2761 411F 20 4D 3F              JSR   KLUGE45
2762 4122 A2 04                 LDX   #F_SRC2
2763 4124 A0 12                 LDY   #F_Z
2764 4126 20 AB 3A              JSR   MOVEIT                   ; Save extra copy of src2
2765 4129              ;                                       ; because recursion trashes
2766 4129              ;                                       ; original copy
2767 4129 A5 6C                 LDA   <SRC2_CLASS              ; 0-normal, 1-denormal
2768 412B D0 05                 BNE   ANNALLLOG                ; If denormal, skip log2()
2769 412D A0 06                 LDY   #FOLOG21X                ; LOG2 (1 + r)
2770 412F 20 88 39              JSR   KLUGE30
2771 4132                       EXPORT ANNALLLOG 
2772 4132              ANNALLLOG                               ;       
2773 4132 20 0C 39              JSR   KLUGE26
2774 4135 A2 62                 LDX   #F_ACCUM
2775 4137 20 CE 3E              JSR   KLUGE67
2776 413A A5 6C                 LDA   <SRC2_CLASS              ; Recheck norm or denorm
2777 413C F0 0B                 BEQ   ANN02
2778 413E A0 0C                 LDY   #FOEXP1X                 ; Denorm case
2779 4140 20 88 39              JSR   KLUGE30
2780 4143 20 82 3A              JSR   FORCEINEXACT
2781 4146 4C 4E 41              JMP   ANN01
2782 4149                       EXPORT ANN02 
2783 4149              ANN02                                   ;       
2784 4149 A0 0E                 LDY   #FOEXP21X                ; (1 + R)^-N - 1
2785 414B 20 88 39              JSR   KLUGE30
2786 414E                       EXPORT ANN01 
2787 414E              ANN01                                   ;       
2788 414E A2 62                 LDX   #F_ACCUM
2789 4150 20 CE 3E              JSR   KLUGE67
2790 4153 A2 12                 LDX   #F_Z                     ; R
2791 4155 A0 62                 LDY   #F_ACCUM
2792 4157 20 02 3F              JSR   KLUGE93
2793 415A 20 40 3A              JSR   CLEARUFLOW
2794 415D 20 44 3A              JSR   CLEAROFLOW
2795 4160 20 48 3F              JSR   KLUGE43
2796 4163 C2 30 18 7B           MOVECA <DEST,<OP0_ADDR
2797 4170              ;                                       ; Set up for class function
2798 4170 20 25 38              JSR   CLASSIFY
2799 4173 8A                    TXA   
2800 4174 C9 FE                 CMP   #FCINF
2801 4176 D0 06                 BNE   z10s03                   ; Is it INF?
2802 4178 20 72 3A              JSR   FORCEOFLOW
2803 417B 4C 85 41              JMP   ANNDOUT
2804 417E C9 00        Z10S03   CMP   #FCNORM                  ; Is it NORMAL?
2805 4180 F0 03                 BEQ   ANNDOUT
2806 4182 20 76 3A              JSR   FORCEUFLOW
2807 4185                       EXPORT ANNDOUT 
2808 4185              ANNDOUT                                 ;       
2809 4185 4C 9C 3B              JMP   RESULTDELIVERED
2810 4188                       ENDP 
2811 4188              ;
2812 4188              ; END OF FILE
2813 4188              ;
2814 4188              ;Constants
2815 4188              ;                  COPY           elems/ELEMC.O
2816 4188              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
2817 4188              ;; File:  ElemC.o                                                        ;
2818 4188              ;; For building 65816 Elems V0.0                                         ;
2819 4188              ;; Status: First attempt                                                 ;
2820 4188              ;; Copyright Apple Computer, Inc., 1983-1986                             ;
2821 4188              ;; All Rights Reserved                                                   ;
2822 4188              ;;                                                                       ;
2823 4188              ;; Written by C. Hausmann, 1983                                          ;
2824 4188              ;;                                                                       ;
2825 4188              ;; Modification History:                                                 ;
2826 4188              ;;      24Mar86 CRL     Rewritten for 65816                              ;
2827 4188              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
2828 4188                       EXPORT COEFFS 
2829 4188              COEFFS   PROC 
2830 4188                       EXPORT LOG21P 
2831 4188 05 00        LOG21P   DC W:5
2832 418A FF 3B CE F6           DC B:$FF,$3B,$CE,$F6,$AF,$46,$46,$B9,$F6,$3F
2833 4194 EB FB 61 4D           DC B:$EB,$FB,$61,$4D,$21,$32,$F4,$94,$F9,$3F
2834 419E 93 78 44 D9           DC B:$93,$78,$44,$D9,$03,$89,$97,$DC,$FB,$3F
2835 41A8 05 1D CA 57           DC B:$05,$1D,$CA,$57,$46,$39,$9E,$9F,$FF,$3F
2836 41B2 9A DC EC 46           DC B:$9A,$DC,$EC,$46,$3A,$C5,$6B,$CD,$01,$C0
2837 41BC E0 FC E6 BA           DC B:$E0,$FC,$E6,$BA,$E7,$97,$83,$B4,$01,$40
2838 41C6                       EXPORT LOG21Q 
2839 41C6 02 00        LOG21Q   DC W:2
2840 41C8 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$00,$80,$FF,$3F
2841 41D2 1D 5E 0A CE           DC B:$1D,$5E,$0A,$CE,$C3,$35,$18,$B8,$00,$C0
2842 41DC 96 1A F4 DD           DC B:$96,$1A,$F4,$DD,$0E,$DF,$3E,$FA,$FF,$3F
2843 41E6                       EXPORT EXP21P 
2844 41E6 03 00        EXP21P   DC W:3
2845 41E8 79 9B 20 1B           DC B:$79,$9B,$20,$1B,$C8,$90,$88,$FF,$EE,$BF
2846 41F2 2F 27 13 B8           DC B:$2F,$27,$13,$B8,$EF,$84,$5C,$DA,$F9,$3F
2847 41FC 45 FD 0F F8           DC B:$45,$FD,$0F,$F8,$EA,$BA,$D3,$97,$03,$40
2848 4206 0C FF BE 95           DC B:$0C,$FF,$BE,$95,$A1,$71,$86,$AB,$09,$40
2849 4210                       EXPORT EXP21Q 
2850 4210 02 00        EXP21Q   DC W:2
2851 4212 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$00,$80,$FF,$3F
2852 421C B4 5A 4B 98           DC B:$B4,$5A,$4B,$98,$02,$70,$48,$D5,$06,$40
2853 4226 80 07 B7 96           DC B:$80,$07,$B7,$96,$2E,$61,$75,$F7,$0A,$40
2854 4230                       EXPORT FPK1 
2855 4230 00 00 00 00  FPK1     DC B:$00,$00,$00,$00,$00,$00,$00,$80,$FF,$3F
2856 423A                       EXPORT FPKM1 
2857 423A 00 00 00 00  FPKM1    DC B:$00,$00,$00,$00,$00,$00,$00,$80,$FF,$BF
2858 4244                       EXPORT FPK2 
2859 4244 00 00 00 00  FPK2     DC B:$00,$00,$00,$00,$00,$00,$00,$80,$00,$40
2860 424E                       EXPORT FPK3 
2861 424E 00 00 00 00  FPK3     DC B:$00,$00,$00,$00,$00,$00,$00,$C0,$00,$40
2862 4258                       EXPORT FPKMAXINT 
2863 4258 00 00 00 00  FPKMAXINT DC B:$00,$00,$00,$00,$00,$00,$FE,$FF,$0D,$40
2864 4262                       EXPORT FPKSQRT2 
2865 4262 84 64 DE F9  FPKSQRT2 DC B:$84,$64,$DE,$F9,$33,$F3,$04,$B5,$FF,$3F
2866 426C                       EXPORT FPKHALF 
2867 426C 00 00 00 00  FPKHALF  DC B:$00,$00,$00,$00,$00,$00,$00,$80,$FE,$3F
2868 4276                       EXPORT FPKSQRTHALF 
2869 4276 84 64 DE F9  FPKSQRTHALF DC B:$84,$64,$DE,$F9,$33,$F3,$04,$B5,$FE,$3F
2870 4280                       EXPORT FPKFOURTH 
2871 4280 00 00 00 00  FPKFOURTH DC B:$00,$00,$00,$00,$00,$00,$00,$80,$FD,$3F
2872 428A                       EXPORT FPK34 
2873 428A 00 00 00 00  FPK34    DC B:$00,$00,$00,$00,$00,$00,$00,$C0,$FE,$3F
2874 4294                       EXPORT FPK78 
2875 4294 00 00 00 00  FPK78    DC B:$00,$00,$00,$00,$00,$00,$00,$E0,$FE,$3F
2876 429E                       EXPORT FPKPI2 
2877 429E 35 C2 68 21  FPKPI2   DC B:$35,$C2,$68,$21,$A2,$DA,$0F,$C9,$FF,$3F
2878 42A8                       EXPORT FPKPI4 
2879 42A8 35 C2 68 21  FPKPI4   DC B:$35,$C2,$68,$21,$A2,$DA,$0F,$C9,$FE,$3F
2880 42B2                       EXPORT FPKE 
2881 42B2 9B 4A BB A2  FPKE     DC B:$9B,$4A,$BB,$A2,$58,$54,$F8,$AD,$00,$40
2882 42BC                       EXPORT FPKLOGE2 
2883 42BC AC 79 CF D1  FPKLOGE2 DC B:$AC,$79,$CF,$D1,$F7,$17,$72,$B1,$FE,$3F
2884 42C6                       EXPORT FPK0 
2885 42C6 00 00 00 00  FPK0     DC B:$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
2886 42D0                       EXPORT FPKM0 
2887 42D0 00 00 00 00  FPKM0    DC B:$00,$00,$00,$00,$00,$00,$00,$00,$00,$80
2888 42DA                       EXPORT FPKINF 
2889 42DA 00 00 00 00  FPKINF   DC B:$00,$00,$00,$00,$00,$00,$00,$00,$FF,$7F
2890 42E4                       EXPORT FPKMINF 
2891 42E4 00 00 00 00  FPKMINF  DC B:$00,$00,$00,$00,$00,$00,$00,$00,$FF,$FF
2892 42EE                       EXPORT F_MAXINT 
2893 42EE FF 7F        F_MAXINT DC B:$FF,$7F
2894 42F0                       EXPORT F_M1 
2895 42F0 FF FF        F_M1     DC B:$FF,$FF
2896 42F2              ;
2897 42F2              ; If the Trigs are not required, then this location specifies the end
2898 42F2              ; of the code file (ptr at start of program points to this address).
2899 42F2              ;
2900 42F2                       EXPORT SINQ 
2901 42F2 03 00        SINQ     DC W:3
2902 42F4 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$00,$80,$FF,$3F
2903 42FE 30 5A A8 A6           DC B:$30,$5A,$A8,$A6,$44,$B8,$D8,$88,$07,$40
2904 4308 20 23 79 09           DC B:$20,$23,$79,$09,$49,$8A,$15,$8A,$0E,$40
2905 4312 2B F2 63 FE           DC B:$2B,$F2,$63,$FE,$26,$FE,$A9,$FA,$13,$40
2906 431C                       EXPORT SINP 
2907 431C 03 00        SINP     DC W:3
2908 431E F5 CB F5 43           DC B:$F5,$CB,$F5,$43,$AE,$86,$50,$C2,$FE,$BF
2909 4328 A2 6B E7 BE           DC B:$A2,$6B,$E7,$BE,$66,$EC,$76,$9E,$06,$40
2910 4332 01 AA C4 C4           DC B:$01,$AA,$C4,$C4,$D6,$A1,$51,$AF,$0C,$C0
2911 433C CE F6 97 A9           DC B:$CE,$F6,$97,$A9,$C4,$FE,$1B,$A7,$11,$40
2912 4346                       EXPORT COSQ 
2913 4346 03 00        COSQ     DC W:3
2914 4348 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$00,$80,$FF,$3F
2915 4352 85 96 DF FB           DC B:$85,$96,$DF,$FB,$95,$6A,$D9,$A6,$07,$40
2916 435C 6B 15 5D E8           DC B:$6B,$15,$5D,$E8,$65,$EA,$A7,$C7,$0E,$40
2917 4366 B2 52 17 7B           DC B:$B2,$52,$17,$7B,$1C,$87,$6E,$D2,$14,$40
2918 4370                       EXPORT COSP 
2919 4370 03 00        COSP     DC W:3
2920 4372 58 D7 F6 A6           DC B:$58,$D7,$F6,$A6,$D7,$18,$7E,$D5,$FB,$BF
2921 437C 72 D0 B3 32           DC B:$72,$D0,$B3,$32,$7E,$93,$64,$E3,$03,$40
2922 4386 45 C0 6B 58           DC B:$45,$C0,$6B,$58,$56,$40,$2D,$A6,$0A,$C0
2923 4390 7A 8C 0F 52           DC B:$7A,$8C,$0F,$52,$68,$AF,$49,$8C,$10,$40
2924 439A                       EXPORT TANQ 
2925 439A 03 00        TANQ     DC W:3
2926 439C 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$00,$80,$FF,$BF
2927 43A6 55 09 C0 83           DC B:$55,$09,$C0,$83,$24,$03,$13,$B5,$05,$40
2928 43B0 CF E0 62 57           DC B:$CF,$E0,$62,$57,$42,$B2,$FF,$D1,$09,$C0
2929 43BA AB 66 76 93           DC B:$AB,$66,$76,$93,$09,$93,$90,$E1,$0A,$40
2930 43C4                       EXPORT TANP 
2931 43C4 03 00        TANP     DC W:3
2932 43C6 38 28 9B D7           DC B:$38,$28,$9B,$D7,$63,$33,$FC,$B1,$E9,$BF
2933 43D0 D1 4C C7 3E           DC B:$D1,$4C,$C7,$3E,$D8,$71,$9D,$AA,$FD,$3F
2934 43DA BB 7D 65 B9           DC B:$BB,$7D,$65,$B9,$24,$8E,$CD,$E9,$03,$C0
2935 43E4 36 18 4B 9D           DC B:$36,$18,$4B,$9D,$70,$36,$9A,$F0,$07,$40
2936 43EE                       EXPORT ATANQ 
2937 43EE 04 00        ATANQ    DC W:4
2938 43F0 AD 5D FA 2A           DC B:$AD,$5D,$FA,$2A,$AE,$1E,$D3,$98,$FF,$3F
2939 43FA D9 EF CD B3           DC B:$D9,$EF,$CD,$B3,$D8,$4C,$79,$8F,$03,$40
2940 4404 68 B3 B8 70           DC B:$68,$B3,$B8,$70,$85,$ED,$37,$8E,$05,$40
2941 440E B8 F3 59 AC           DC B:$B8,$F3,$59,$AC,$A1,$BE,$A4,$CD,$05,$40
2942 4418 56 C6 F0 4C           DC B:$56,$C6,$F0,$4C,$55,$9C,$05,$C4,$04,$40
2943 4422                       EXPORT ATANP 
2944 4422 04 00        ATANP    DC W:4
2945 4424 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$00,$80,$FF,$3F
2946 442E 30 0E 92 1F           DC B:$30,$0E,$92,$1F,$13,$6C,$3B,$A2,$02,$40
2947 4438 6F 48 3A FA           DC B:$6F,$48,$3A,$FA,$3D,$59,$C8,$C3,$03,$40
2948 4442 45 D9 F5 DD           DC B:$45,$D9,$F5,$DD,$38,$68,$AE,$82,$03,$40
2949 444C 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
2950 4456                       EXPORT FPKX2 
2951 4456 6A E2 98 81  FPKX2    DC B:$6A,$E2,$98,$81,$2C,$3A,$CD,$93,$FE,$3F
2952 4460                       EXPORT FPKX2FX2 
2953 4460 62 64 DB 5F  FPKX2FX2 DC B:$62,$64,$DB,$5F,$B1,$86,$2A,$DC,$FA,$3F
2954 446A                       EXPORT FPKATNCONS 
2955 446A 8A B1 6A F6  FPKATNCONS DC B:$8A,$B1,$6A,$F6,$F4,$A2,$30,$89,$FD,$3F
2956 4474                       EXPORT FPKARAND 
2957 4474 00 00 00 00  FPKARAND DC B:$00,$00,$00,$00,$00,$00,$4E,$83,$0D,$40
2958 447E                       EXPORT FPKPRAND 
2959 447E 00 00 00 00  FPKPRAND DC B:$00,$00,$00,$00,$FE,$FF,$FF,$FF,$1D,$40
2960 4488                       ENDP 
2961 4488              ;
2962 4488                       EXPORT OPERAND 
2963 4488              OPERAND  PROC 
2964 4488 82 00                 DC W:DEST
2965 448A 96 00                 DC W:SRC
2966 448C A0 00                 DC W:SRC2
2967 448E 70 00                 DC W:I_SRC
2968 4490 C3 00                 DC W:I_TEMP
2969 4492 C5 00                 DC W:J_TEMP
2970 4494 C7 00                 DC W:W_TEMP
2971 4496 D1 00                 DC W:X_TEMP
2972 4498 DB 00                 DC W:Y_TEMP
2973 449A E5 00                 DC W:Z_TEMP
2974 449C              ; Need to define ptrs to the tables of coefficients and constants so that
2975 449C              ; they can be pushed onto the stack by address.
2976 449C              ;
2977 449C                       EXPORT C_LOG21P 
2978 449C 88 41        C_LOG21P DC W:LOG21P
2979 449E                       EXPORT C_LOG21Q 
2980 449E C6 41        C_LOG21Q DC W:LOG21Q
2981 44A0                       EXPORT C_EXP21P 
2982 44A0 E6 41        C_EXP21P DC W:EXP21P
2983 44A2                       EXPORT C_EXP21Q 
2984 44A2 10 42        C_EXP21Q DC W:EXP21Q
2985 44A4                       EXPORT C_FPK1 
2986 44A4 30 42        C_FPK1   DC W:FPK1
2987 44A6                       EXPORT C_FPKM1 
2988 44A6 3A 42        C_FPKM1  DC W:FPKM1
2989 44A8                       EXPORT C_FPK2 
2990 44A8 44 42        C_FPK2   DC W:FPK2
2991 44AA                       EXPORT C_FPK3 
2992 44AA 4E 42        C_FPK3   DC W:FPK3
2993 44AC                       EXPORT C_FPKMAXINT 
2994 44AC 58 42        C_FPKMAXINT DC W:FPKMAXINT
2995 44AE                       EXPORT C_FPKSQRT2 
2996 44AE 62 42        C_FPKSQRT2 DC W:FPKSQRT2
2997 44B0                       EXPORT C_FPKHALF 
2998 44B0 6C 42        C_FPKHALF DC W:FPKHALF
2999 44B2                       EXPORT C_FPKSQTHALF 
3000 44B2 76 42        C_FPKSQTHALF DC W:FPKSQRTHALF
3001 44B4                       EXPORT C_FPKFOURTH 
3002 44B4 80 42        C_FPKFOURTH DC W:FPKFOURTH
3003 44B6                       EXPORT C_FPK34 
3004 44B6 8A 42        C_FPK34  DC W:FPK34
3005 44B8                       EXPORT C_FPK78 
3006 44B8 94 42        C_FPK78  DC W:FPK78
3007 44BA                       EXPORT C_FPKPI2 
3008 44BA 9E 42        C_FPKPI2 DC W:FPKPI2
3009 44BC                       EXPORT C_FPKPI4 
3010 44BC A8 42        C_FPKPI4 DC W:FPKPI4
3011 44BE                       EXPORT C_FPKE 
3012 44BE B2 42        C_FPKE   DC W:FPKE
3013 44C0                       EXPORT C_FPKLOGE2 
3014 44C0 BC 42        C_FPKLOGE2 DC W:FPKLOGE2
3015 44C2                       EXPORT C_FPK0 
3016 44C2 C6 42        C_FPK0   DC W:FPK0
3017 44C4                       EXPORT C_FPKM0 
3018 44C4 D0 42        C_FPKM0  DC W:FPKM0
3019 44C6                       EXPORT C_FPKINF 
3020 44C6 DA 42        C_FPKINF DC W:FPKINF
3021 44C8                       EXPORT C_FPKMINF 
3022 44C8 E4 42        C_FPKMINF DC W:FPKMINF
3023 44CA                       EXPORT C_SINQ 
3024 44CA F2 42        C_SINQ   DC W:SINQ
3025 44CC                       EXPORT C_SINP 
3026 44CC 1C 43        C_SINP   DC W:SINP
3027 44CE                       EXPORT C_COSQ 
3028 44CE 46 43        C_COSQ   DC W:COSQ
3029 44D0                       EXPORT C_COSP 
3030 44D0 70 43        C_COSP   DC W:COSP
3031 44D2                       EXPORT C_TANQ 
3032 44D2 9A 43        C_TANQ   DC W:TANQ
3033 44D4                       EXPORT C_TANP 
3034 44D4 C4 43        C_TANP   DC W:TANP
3035 44D6                       EXPORT C_ATANQ 
3036 44D6 EE 43        C_ATANQ  DC W:ATANQ
3037 44D8                       EXPORT C_ATANP 
3038 44D8 22 44        C_ATANP  DC W:ATANP
3039 44DA                       EXPORT C_FPKX2 
3040 44DA 56 44        C_FPKX2  DC W:FPKX2
3041 44DC                       EXPORT C_FPKX2FX2 
3042 44DC 60 44        C_FPKX2FX2 DC W:FPKX2FX2
3043 44DE                       EXPORT C_FPKATNCONS 
3044 44DE 6A 44        C_FPKATNCONS DC W:FPKATNCONS
3045 44E0                       EXPORT C_FPKARAND 
3046 44E0 74 44        C_FPKARAND DC W:FPKARAND
3047 44E2                       EXPORT C_FPKPRAND 
3048 44E2 7E 44        C_FPKPRAND DC W:FPKPRAND
3049 44E4 64 00                 DC W:EXCPTION
3050 44E6 66 00                 DC W:OLD_ENV
3051 44E8 68 00                 DC W:SAVE_ENV
3052 44EA B4 00                 DC W:V_TEMP
3053 44EC                       EXPORT C_MAXINT 
3054 44EC EE 42        C_MAXINT DC W:F_MAXINT
3055 44EE                       ENDP 
3056 44EE              ;
3057 44EE              ; END OF FILE
3058 44EE              ;
3059 44EE              ; Sin, Cos, Tan, ATan, Random
3060 44EE              ;                  COPY           elems/ELEM4.O.A
3061 44EE              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3062 44EE              ;; File:  Elem4.O.A                                                      ;
3063 44EE              ;; For building 65816 Elems V0.0                                         ;
3064 44EE              ;; Status: First attempt                                                 ;
3065 44EE              ;; Copyright Apple Computer, Inc., 1983-1986                             ;
3066 44EE              ;; All Rights Reserved                                                   ;
3067 44EE              ;;                                                                       ;
3068 44EE              ;; Written by C. Hausmann, 1983                                          ;
3069 44EE              ;;                                                                       ;
3070 44EE              ;; Modification History:                                                 ;
3071 44EE              ;;      24Mar86 CRL     Rewritten for 65816                              ;
3072 44EE              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3073 44EE              ;
3074 44EE              ; Sine function.
3075 44EE              ; Input:  DEST       = operand T
3076 44EE              ;         SRC2_CLASS = class (-4..1)
3077 44EE              ;         SRC2_SIGN  = sign of T
3078 44EE              ; Output: DEST       = result
3079 44EE              ; Uses:   A0_ADDR..A2_ADDR, OP1_ADDR
3080 44EE              ;         Cells: W_TEMP, X_TEMP, Y_TEMP
3081 44EE              ;
3082 44EE              ;
3083 44EE              ; About the argument reduction:  T is reduced MOD approximate pi/2,
3084 44EE              ; leaving the magnitude no bigger than approximate pi/4.
3085 44EE              ; Recall the identities:
3086 44EE              ;       sin (T)               =  sin (T)
3087 44EE              ;       sin (pi/2 + T)        =  cos (T)
3088 44EE              ;       sin (pi + T)          = -sin (T)
3089 44EE              ;       sin (3pi/2 + T)       = -cos (T)
3090 44EE              ;       sin (2pi + T)         =  sin (T)
3091 44EE              ; Then if input T = q*(pi/2) + r,
3092 44EE              ;       q mod 2 determines whether to use sin (0) or cos (1), and
3093 44EE              ;       q mod 4 determines whether to negate result (2 or 3).
3094 44EE              ;
3095 44EE              ;
3096 44EE                       EXPORT SINTOP 
3097 44EE              SINTOP   PROC 
3098 44EE                       LONGA OFF
3099 44EE                       LONGI OFF
3100 44EE 20 2C 46              JSR   KLUGE6
3101 44F1 D0 03                 BNE   SINCOSCOM
3102 44F3 4C 9C 3B              JMP   RESULTDELIVERED          ; SIN (+-0) is +-0
3103 44F6 10 03        SINCOSCOM BPL   z1s05
3104 44F8 4C 77 3B              JMP   ERRORNAN                 ; SIN (INF) is illegal
3105 44FB              ;
3106 44FB              ; Have finite, nonzero argument
3107 44FB              ;
3108 44FB 20 54 45     Z1S05    JSR   TRIGREDUCTION            ; T <-- T REM PI/2
3109 44FE A9 01                 LDA   #$1
3110 4500 24 F4                 BIT   <D2_TEMP
3111 4502 D0 06                 BNE   z1s01
3112 4504 20 75 45              JSR   SINGUTS                  ; Even, use SIN
3113 4507 4C 0D 45              JMP   z1s03
3114 450A 20 BA 45     Z1S01    JSR   COSGUTS                  ; Odd, use COS
3115 450D A9 00        Z1S03    LDA   #$0                      ; Quo MOD 4
3116 450F 85 F5                 STA   <D2_TEMP+1
3117 4511 A5 F4                 LDA   <D2_TEMP
3118 4513 29 03                 AND   #$3
3119 4515 38                    SEC   
3120 4516 E9 02                 SBC   #$2                      ; >= 0 only if MOD 2 or 3
3121 4518 85 F4                 STA   <D2_TEMP
3122 451A A5 F5                 LDA   <D2_TEMP+1
3123 451C E9 00                 SBC   #$0
3124 451E 85 F5                 STA   <D2_TEMP+1
3125 4520 30 03                 BMI   TRIGFINI
3126 4522 20 CC 3E              JSR   KLUGE62
3127 4525              ;
3128 4525              ; Common trig finish:
3129 4525              ;       Clear uflow, except when denormalized.
3130 4525              ;       Set inexact.
3131 4525              ;       If result is denormal, set underflow.
3132 4525              ;       Exit.
3133 4525              ;
3134 4525                       EXPORT TRIGFINI 
3135 4525              TRIGFINI                                ;       
3136 4525 20 40 3A              JSR   CLEARUFLOW               ; Will check for error later
3137 4528 20 82 3A              JSR   FORCEINEXACT
3138 452B 20 C5 3E              JSR   KLUGE61
3139 452E E0 01                 CPX   #FCDENORM
3140 4530 D0 03                 BNE   z2s13
3141 4532 20 76 3A              JSR   FORCEUFLOW
3142 4535 4C 9C 3B     Z2S13    JMP   RESULTDELIVERED
3143 4538              ;
3144 4538              ; Cosine function.
3145 4538              ; Input:  DEST       = operand T
3146 4538              ;         SRC2_CLASS = class (-4..1)
3147 4538              ;         SRC2_SIGN  = sign of T
3148 4538              ; Output: DEST       = result
3149 4538              ; Uses:   A0_ADDR..A2_ADDR, OP1_ADDR
3150 4538              ;         Cells: W_TEMP, X_TEMP, Y_TEMP
3151 4538              ;
3152 4538              ;
3153 4538              ; About the argument reduction:  T is reduced MOD approximate pi/2,
3154 4538              ; leaving its magnitude no bigger than approximate pi/4.
3155 4538              ; Recall the identities:
3156 4538              ;       cos (T)                  =  cos (T)
3157 4538              ;       cos (pi/2 + T)           = -sin (T)
3158 4538              ;       cos (pi + T)             = -cos (T)
3159 4538              ;       cos (3pi/2 + T)          =  sin (T)
3160 4538              ;       cos (2pi + T)            =  cos (T)
3161 4538              ; Then if input T = q*(pi/2) + r,
3162 4538              ;      q mod 2 determines whether to use cos (0) or sin (1), and
3163 4538              ;      (q+1) mod 4 determines whether to negate result (2 or 3).
3164 4538              ;
3165 4538              ;
3166 4538              ;
3167 4538                       EXPORT KLUGE39 
3168 4538              KLUGE39                                 ;       
3169 4538 A5 6D                 LDA   <SRC2_SIGN
3170 453A 85 6F                 STA   <CLASS_SIGN
3171 453C A9 21                 LDA   #NANTRIG
3172 453E 85 6E                 STA   <CLASS_CODE
3173 4540 60                    RTS   
3174 4541                       EXPORT COSTOP 
3175 4541              COSTOP                                  ;       
3176 4541 20 38 45              JSR   KLUGE39
3177 4544 A0 00                 LDY   #$0                      ; Quotient adjustment
3178 4546 84 F5                 STY   <D2_TEMP+1               ; Quo <-- 1
3179 4548 C8                    INY   
3180 4549 84 F4                 STY   <D2_TEMP
3181 454B A5 6C                 LDA   <SRC2_CLASS
3182 454D C9 FF                 CMP   #FCZERO
3183 454F D0 A5                 BNE   SINCOSCOM
3184 4551 4C 5D 3B              JMP   P1STUFF                  ; COS (+-0) is 1
3185 4554              ;
3186 4554              ; Reduce DEST mod approximate pi/2, adding quotient to D2.
3187 4554              ; Input:  DEST    = operand T
3188 4554              ;         D2_TEMP = quotient adjustment
3189 4554              ; Output: DEST    = reduced argument
3190 4554              ;         D2_TEMP = adjusted quotient
3191 4554              ; Uses:   J_TEMP  = quotient
3192 4554              ;
3193 4554                       EXPORT TRIGREDUCTION 
3194 4554              TRIGREDUCTION                           ;       
3195 4554 A2 32                 LDX   #F_FPKPI2                ; Approximate PI/2
3196 4556 20 12 39              JSR   KLUGE99                  ; T REM (PI/2), low byte
3197 4559              ;                                       ; of quo in X, sign in X.hi
3198 4559              ;
3199 4559              ; Move QUO to J_TEMP - converting to 2 byte quantity
3200 4559              ;
3201 4559 64 C6                 STZ   J_TEMP+1
3202 455B 8A                    TXA   
3203 455C 29 7F                 AND   #$7F
3204 455E 85 C5                 STA   J_TEMP
3205 4560 C0 00                 CPY   #0
3206 4562 F0 03                 BEQ   Z3S01
3207 4564 20 CE 3A              JSR   NEGATE                   ; Negate J_TEMP if neg QUO
3208 4567              ;
3209 4567              ; Add QUO to quotient adjustment
3210 4567              ;
3211 4567 18           Z3S01    CLC   
3212 4568 A5 F4                 LDA   <D2_TEMP
3213 456A 65 C5                 ADC   <J_TEMP
3214 456C 85 F4                 STA   <D2_TEMP
3215 456E A5 F5                 LDA   <D2_TEMP+1
3216 4570 65 C6                 ADC   <J_TEMP+1
3217 4572 85 F5                 STA   <D2_TEMP+1
3218 4574 60                    RTS   
3219 4575              ;
3220 4575              ; Evaluate sin (T) for reduced |T| <= pi/4.
3221 4575              ; Use approximation (S = T*T)    T - (T*S*(P(S) / Q(S)))
3222 4575              ; Input:  DEST      = T
3223 4575              ; Output: DEST      = sin (T)
3224 4575              ; Uses:   A0_ADDR - A2_ADDR, OP1_ADDR
3225 4575              ;         Cells: W_TEMP, X_TEMP, Y_TEMP
3226 4575              ; Note use of sin/cos common routine depends on placement of Q coef table
3227 4575              ; immediately before P coef table.
3228 4575              ;
3229 4575 A9 42        SINGUTS  LDA   #F_SINQ
3230 4577 20 91 45              JSR   POVERQ                   ; X <-- P/Q
3231 457A              ;                                       ; Z <-- T^3
3232 457A A2 62                 LDX   #F_ACCUM                 ; ACCUM = T^3
3233 457C 20 02 39              JSR   KLUGE21
3234 457F A2 0E        KLUGE94  LDX   #F_X                     ; X
3235 4581 4C 71 3D              JMP   KLUGE90
3236 4584              ;
3237 4584              ; Common routine for trig functions quts.
3238 4584              ; Input:  DEST          = operand T
3239 4584              ;         Accum         = index to Q coef table, with P immediately after in
3240 4584              ;                         memory
3241 4584              ; Output: W_TEMP        = T*T
3242 4584              ;         Z_TEMP        = T*T*T
3243 4584              ;         X_TEMP        = (T*T) * (P(T*T) / Q(T*T))
3244 4584              ; Uses  : Y_TEMP        = Q(T*T)
3245 4584              ;         A0_addr, A2_addr  (as temporary pointers)
3246 4584              ;
3247 4584                       EXPORT T2POVERQ 
3248 4584              T2POVERQ                                ;       
3249 4584 20 91 45              JSR   POVERQ
3250 4587 20 00 39              JSR   KLUGE22
3251 458A A2 62                 LDX   #F_ACCUM                 ; POVERQ does not alter Z.
3252 458C                       EXPORT KLUGE48 
3253 458C              KLUGE48                                 ;       
3254 458C A0 12                 LDY   #F_Z                     ; To deliver T^3 in Z, it
3255 458E 4C AB 3A              JMP   MOVEIT                   ;    must transfer from ACCUM
3256 4591              ;
3257 4591              ; Common routine for trig functions guts.
3258 4591              ; Called by T3POVERQ and ATANGUTS.
3259 4591              ; Input:  DEST          = operand T
3260 4591              ;         OP1_Addr      = ptr to Q coef table, with P immediately after in
3261 4591              ;                         memory
3262 4591              ; Output: W_TEMP        = T*T
3263 4591              ;         X_TEMP        = (P(T*T) / Q(T*T))
3264 4591              ;         ACCUM         = T^3
3265 4591              ; Uses  : Y_TEMP        = Q(T*T)
3266 4591              ;         A0_addr, A2_addr  (as temporary pointers)
3267 4591              ;
3268 4591              ;    NOTE : Use of #F_ACCUM added by C.R. Lewis on 2-Feb-84 to avoid trashing
3269 4591              ;           Z_DEST.  Changes both here and in T2POVERQ.
3270 4591              ;
3271 4591                       EXPORT POVERQ 
3272 4591              POVERQ                                  ;       
3273 4591 85 C3                 STA   <I_TEMP                  ; Index to table of ptr to coefs
3274 4593 20 5D 3C              JSR   KLUGE42
3275 4596 A2 0C                 LDX   #F_W                     ; W
3276 4598 20 08 39              JSR   KLUGE24
3277 459B              ;
3278 459B              ; Compute Z = T^3
3279 459B              ;
3280 459B A2 0C                 LDX   #F_W                     ; W = T*T
3281 459D 20 4F 3F              JSR   KLUGE44                  ; Copy W into ACCUM
3282 45A0 A2 00                 LDX   #F_DEST                  ; Dest = T
3283 45A2 20 0E 39              JSR   KLUGE27
3284 45A5              ;
3285 45A5              ; Compute P/Q
3286 45A5              ;
3287 45A5 A2 10                 LDX   #F_Y                     ; Result field
3288 45A7 20 CE 39              JSR   KLUGE33                  ; Y_TEMP <-- Q (T*T)
3289 45AA E6 C3                 INC   <I_TEMP
3290 45AC E6 C3                 INC   <I_TEMP
3291 45AE A2 0E                 LDX   #F_X                     ; Result field
3292 45B0 20 CE 39              JSR   KLUGE33                  ; X <-- P(T*T)
3293 45B3 A2 10                 LDX   #F_Y                     ; P(T*T)
3294 45B5 A0 0E                 LDY   #F_X                     ; Q(T*T)
3295 45B7 4C 02 3F              JMP   KLUGE93
3296 45BA              ;
3297 45BA              ; Evaluate cos (T) for reduced |T| <= pi/4.
3298 45BA              ; Use approximation (S = T*T):
3299 45BA              ;    (S < 1/4):        1 - S/2  +  S*S*(P(S) /Q(S))
3300 45BA              ;    else:             with Z = |X| - 0.5
3301 45BA              ;                      0.875 - (Z/2 + (Z*Z/2 - S*S*(P(S) / Q(S))))
3302 45BA              ; Input:  DEST      = T
3303 45BA              ; Output: DEST      = cos (T)
3304 45BA              ; Uses:   A0_ADDR - A2_ADDR, OP1_ADDR
3305 45BA              ;         cells:  W_TEMP, X_TEMP, Y_TEMP
3306 45BA              ; Note use of sin/cos common routine depends on placement of Q coef table
3307 45BA              ; immediately before P coef table.
3308 45BA              ;
3309 45BA A9 46        COSGUTS  LDA   #F_COSQ                  ; COS Q coef table,
3310 45BC              ;                                       ; P thereafter
3311 45BC 20 84 45              JSR   T2POVERQ                 ; W <-- T*T
3312 45BF              ;                                       ; Z <-- T^3
3313 45BF              ;                                       ; X <-- T^2*P/Q
3314 45BF 20 00 39              JSR   KLUGE22
3315 45C2              ;
3316 45C2              ; Now compare T*T in W with 1/4, to determine which formula to continue with.
3317 45C2              ;
3318 45C2 A2 0C                 LDX   #F_W                     ; W
3319 45C4 A0 2C                 LDY   #F_FPKFOURTH             ; 1/4
3320 45C6 20 50 3B              JSR   KLUGE28
3321 45C9 70 14                 FBGT CGBIG
3322 45CB              ;
3323 45CB              ; Finish with first formula above.
3324 45CB              ;
3325 45CB 20 06 39              JSR   KLUGE23
3326 45CE A2 0C                 LDX   #F_W                     ; W
3327 45D0 A0 0E                 LDY   #F_X                     ; X = T^4 * P/Q
3328 45D2 20 73 3D              JSR   KLUGE91
3329 45D5 A2 0E                 LDX   #F_X                     ; Result = current X
3330 45D7 20 A9 3A              JSR   KLUGE8
3331 45DA A2 1C                 LDX   #F_FPK1                  ; 1
3332 45DC 4C 1A 39              JMP   KLUGE97                  ; SAME AS TGFIN
3333 45DF              ;
3334 45DF              ; Evaluate long form of expression.
3335 45DF              ;
3336 45DF 20 D2 3E     CGBIG    JSR   KLUGE63
3337 45E2 A2 28                 LDX   #F_FPKHALF               ; 1/2
3338 45E4 20 71 3D              JSR   KLUGE90
3339 45E7 20 5D 3C              JSR   KLUGE42
3340 45EA 20 06 39              JSR   KLUGE23
3341 45ED A2 0C                 LDX   #F_W                     ; W
3342 45EF 20 FA 38              JSR   KLUGE20
3343 45F2 A2 0E                 LDX   #F_X                     ; X = T^4*P/Q
3344 45F4 20 71 3D              JSR   KLUGE90
3345 45F7 A2 0C                 LDX   #F_W                     ; W = T'/2
3346 45F9 20 1A 39              JSR   KLUGE97
3347 45FC 20 CC 3E              JSR   KLUGE62
3348 45FF A2 30                 LDX   #F_FPK78                 ; 0.875 = 7/8
3349 4601 4C 1A 39              JMP   KLUGE97                  ; SAME AS TGFIN
3350 4604                       ENDP 
3351 4604              ;
3352 4604              ; END OF FILE
3353 4604              ;
3354 4604              ;                  COPY           elems/ELEM4.O.B
3355 4604              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3356 4604              ;; File:  Elem4.o.b                                                      ;
3357 4604              ;; For building 65816 Elems V0.0                                         ;
3358 4604              ;; Status: First attempt                                                 ;
3359 4604              ;; Copyright Apple Computer, Inc., 1983-1986                             ;
3360 4604              ;; All Rights Reserved                                                   ;
3361 4604              ;;                                                                       ;
3362 4604              ;; Written by C. Hausmann, 1983                                          ;
3363 4604              ;;                                                                       ;
3364 4604              ;; Modification History:                                                 ;
3365 4604              ;;      24Mar86 CRL     Rewritten for 65816                              ;
3366 4604              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3367 4604              ;
3368 4604              ; Tangent function.
3369 4604              ; Input:   DEST     = operand T
3370 4604              ;          SRC2_CLASS = class (-4..1)
3371 4604              ;          SRC2_SIGN  = sign  ($0-positive, $80 - negative)
3372 4604              ; Output:  DEST     = result
3373 4604              ; Uses  :  A0_ADDR - A2_ADDR, OP1_ADDR
3374 4604              ;          cells:  W_TEMP, X_TEMP, Y_TEMP, D2_TEMP
3375 4604              ;
3376 4604              ; About the argument reduction:  T is reduced MOD approximate pi/2,
3377 4604              ; leaving its magnitude no bigger than approximate pi/4.
3378 4604              ; Recall the identities:
3379 4604              ;        tan (T)                =  tan(T)
3380 4604              ;        tan(pi/2 + T)          =  -1/tan(T)
3381 4604              ;        tan (pi + T)           =  tan (T)
3382 4604              ; Then if input T = q*(pi/2) + r,
3383 4604              ;     q mod 2 determines whether to negate and reciprocate tan.
3384 4604              ;
3385 4604                       EXPORT TANTOP 
3386 4604              TANTOP   PROC 
3387 4604                       LONGA OFF
3388 4604                       LONGI OFF
3389 4604 20 2C 46              JSR   KLUGE6
3390 4607 10 03                 BPL   z4s01
3391 4609 4C 77 3B              JMP   ERRORNAN                 ; INF is illegal
3392 460C D0 03        Z4S01    BNE   z4s02
3393 460E 4C 9C 3B              JMP   RESULTDELIVERED          ; TAN(+-0) is +-0
3394 4611              ;
3395 4611              ; Have finite, nonzero argument.
3396 4611              ;
3397 4611 20 54 45     Z4S02    JSR   TRIGREDUCTION
3398 4614 20 38 46              JSR   TANGUTS
3399 4617              ;
3400 4617              ;
3401 4617              ; check q mod 2
3402 4617              ;
3403 4617 66 F4                 ROR   <D2_TEMP                 ; C bit <-- Quo mod 2
3404 4619 90 0E                 BCC   z4s21
3405 461B 20 CC 3E              JSR   KLUGE62
3406 461E 20 E9 46              JSR   KLUGE34
3407 4621 20 92 3A              JSR   TESTDIVZER               ; Result = +/-INF?
3408 4624 F0 03                 BEQ   z4s21
3409 4626 20 CC 3E              JSR   KLUGE62
3410 4629 4C 25 45     Z4S21    JMP   TRIGFINI
3411 462C                       EXPORT KLUGE6 
3412 462C              KLUGE6                                  ;       
3413 462C 20 38 45              JSR   KLUGE39
3414 462F 64 F5                 STZ   <D2_TEMP+1               ; D2_TEMP <-- 0
3415 4631 64 F4                 STZ   <D2_TEMP
3416 4633 A5 6C                 LDA   <SRC2_CLASS
3417 4635 C9 FF                 CMP   #FCZERO
3418 4637 60                    RTS   
3419 4638              ;
3420 4638              ; Evaluate tan (T) for |T| <= pi/4.
3421 4638              ; Use formulas:  (S = T*T)
3422 4638              ;      S <= 1/4:           T + (T^3/3 + T^5*P(S)/Q*S))
3423 4638              ;      else:               T' = (T - 3/4)/3
3424 4638              ;                          T  + S/4 + S*(T' + T^3*P(S)/Q(S))
3425 4638              ;
3426 4638 A9 4A        TANGUTS  LDA   #F_TANQ                  ; Tan Q coefs, P immed after
3427 463A 20 84 45              JSR   T2POVERQ                 ; X <-- T^2*P/Q
3428 463D              ;
3429 463D              ; Compute T^5*P/Q, common to both formulas.
3430 463D              ;
3431 463D A2 12                 LDX   #F_Z                     ; Z = T^3
3432 463F 20 02 39              JSR   KLUGE21
3433 4642              ;
3434 4642              ; Compare T*T with 1/4 to decide which formula to continue.
3435 4642              ;
3436 4642 A2 0C                 LDX   #F_W                     ; W = T*T
3437 4644 A0 2C                 LDY   #F_FPKFOURTH             ; 1/4
3438 4646 20 50 3B              JSR   KLUGE28
3439 4649 70 13                 FBGT TGBIG
3440 464B              ;
3441 464B              ; Using first, simpler formula.
3442 464B              ;
3443 464B A2 22                 LDX   #F_FPK3                  ; 3
3444 464D A0 12                 LDY   #F_Z                     ; Z = T^3
3445 464F 20 02 3F              JSR   KLUGE93
3446 4652 A2 12                 LDX   #F_Z                     ; Z
3447 4654 A0 0E                 LDY   #F_X                     ; X
3448 4656 20 1C 39              JSR   KLUGE98
3449 4659 A2 0E                 LDX   #F_X
3450 465B 4C 1A 39              JMP   KLUGE97                  ; = TGFIN, Go add to T and exit
3451 465E              ;
3452 465E              ; Using more complicated formula.
3453 465E              ;
3454 465E 20 6B 3C     TGBIG    JSR   KLUGE51                  ; Y <-- T
3455 4661 A2 2E                 LDX   #F_FPK34                 ; 3/4
3456 4663 A0 10                 LDY   #F_Y                     ; Y
3457 4665 20 73 3D              JSR   KLUGE91
3458 4668 A2 22                 LDX   #F_FPK3                  ; 3
3459 466A A0 10                 LDY   #F_Y                     ; Y
3460 466C 20 02 3F              JSR   KLUGE93
3461 466F A2 0C                 LDX   #F_W                     ; W = T*T
3462 4671 A0 10                 LDY   #F_Y                     ; Y = T'
3463 4673 20 FC 38              JSR   KLUGE25
3464 4676 A2 0E                 LDX   #F_X                     ; X = T^5*P/Q
3465 4678 A0 10                 LDY   #F_Y                     ; Y
3466 467A 20 1C 39              JSR   KLUGE98
3467 467D A2 2C                 LDX   #F_FPKFOURTH             ; 1/4
3468 467F 20 08 39              JSR   KLUGE24
3469 4682 A2 0C                 LDX   #F_W                     ; W
3470 4684 A0 10                 LDY   #F_Y                     ; Y
3471 4686 20 1C 39              JSR   KLUGE98
3472 4689 A2 10                 LDX   #F_Y                     ; Set up for last add...
3473 468B 4C 1A 39     TGFIN    JMP   KLUGE97
3474 468E              ; Finish off tangent, adding (A0_addr) into T in Result.
3475 468E              ;
3476 468E              ;
3477 468E              ; Arctan (T) for any  -INF  <= T <= INF.
3478 468E              ; Input:  DEST       = operand T
3479 468E              ;         SRC2_CLASS = class (-4..1) for DEST
3480 468E              ; Output: DEST       = result
3481 468E              ; Uses:   A0_ADDR - A2-ADDR, OP1_ADDR
3482 468E              ;         Cells:  W_TEMP, X_TEMP, Y_TEMP, Z_TEMP, SRC (as a temporary),
3483 468E              ;                 D2_TEMP
3484 468E              ;
3485 468E              ; About the argument reduction:  ATAN (T) is evaluated for 0 <= T <= 1.
3486 468E              ; Recall the identities:
3487 468E              ;    atan (T)                = atan (T)
3488 468E              ;    atan (-T)               = -atan (T)
3489 468E              ;    atan (1/T)              = pi/2 - atan (T)
3490 468E              ; If T < 0 then atan (-T) is computed, and the result negated.
3491 468E              ; To compute atan of reduced T use formulas:
3492 468E              ;      T <= ATnCons  = 0.267...   T  -  T * P(T*T) / Q(T*T)
3493 468E              ;      else                       T  -  (A  +  (B*P(B*B) / Q(B*B) + x2fx2))
3494 468E              ;               where  x2 and x2fx2 are constants, about 0.5 and 0.05, and
3495 468E              ;               A = (T - x2)/(1 + (1/(T*x2))), and
3496 468E              ;               B = (T - x2)/(1 +    (T*x2)).
3497 468E              ;
3498 468E                       EXPORT ATANTOP 
3499 468E              ATANTOP                                 ;       
3500 468E A5 6C                 LDA   <SRC2_CLASS
3501 4690 C9 FF                 CMP   #FCZERO
3502 4692 10 0F                 BPL   ATFINITE                 ; 0, norm, or denorm
3503 4694 A2 32                 LDX   #F_FPKPI2
3504 4696 20 A9 3A              JSR   KLUGE8
3505 4699              ;                                       ; Infinite case
3506 4699 A5 6D                 LDA   <SRC2_SIGN               ; Force sign of result
3507 469B 10 03                 BPL   z5s01
3508 469D 20 CC 3E              JSR   KLUGE62
3509 46A0 4C A5 46     Z5S01    JMP   ATQUICK
3510 46A3 D0 03        ATFINITE BNE   ATHARD                   ; Zero if result is zero
3511 46A5 4C 9C 3B     ATQUICK  JMP   RESULTDELIVERED
3512 46A8 20 D2 3E     ATHARD   JSR   KLUGE63
3513 46AB 20 B8 46              JSR   ATANGUTS
3514 46AE A5 6D                 LDA   <SRC2_SIGN               ; Replace sign of ATAN
3515 46B0 10 03                 BPL   z6s01                    ; Better to just take abs.?
3516 46B2 20 CC 3E              JSR   KLUGE62
3517 46B5 4C 25 45     Z6S01    JMP   TRIGFINI
3518 46B8              ;
3519 46B8              ; Use D2_TEMP to store Boolean about whether input T was inverted in order
3520 46B8              ; to obtain an argument no bigger than one.
3521 46B8              ;
3522 46B8 A9 00        ATANGUTS LDA   #$0
3523 46BA 85 F4                 STA   <D2_TEMP                 ; Set to false
3524 46BC A2 00                 LDX   #F_DEST                  ; T
3525 46BE A0 1C                 LDY   #F_FPK1                  ; 1
3526 46C0 20 50 3B              JSR   KLUGE28
3527 46C3 30 09 F0 07           FBLE AGNOINV
3528 46C7 A9 01                 LDA   #$1                      ; Set to true
3529 46C9 85 F4                 STA   <D2_TEMP
3530 46CB 20 E9 46              JSR   KLUGE34
3531 46CE              ;
3532 46CE              ; Store a copy of reduced T on stack for later.
3533 46CE              ;
3534 46CE A2 00        AGNOINV  LDX   #F_DEST                  ; SRC <-- copy of DEST
3535 46D0 A0 02                 LDY   #F_SRC
3536 46D2 20 AB 3A              JSR   MOVEIT
3537 46D5              ;
3538 46D5              ; Select short or long form based on Result vs. ATnCons, about 0.268.
3539 46D5              ;
3540 46D5 A2 00                 LDX   #F_DEST                  ; Result
3541 46D7 A0 56                 LDY   #F_FPKATNCONS
3542 46D9 20 50 3B              JSR   KLUGE28
3543 46DC 70 17                 FBGT AGLONGFORM                ; Compare as Res - ATnCons
3544 46DE              ;
3545 46DE              ; Short form.
3546 46DE              ;
3547 46DE              ;               ;MOVE            C_ATANQ,A1_ADDR
3548 46DE              ;                                       ; Double check to see if
3549 46DE              ;                                       ; OP1 is the correct zero
3550 46DE              ;                                       ; p loc
3551 46DE A9 4E                 LDA   #F_ATANQ
3552 46E0 20 91 45              JSR   POVERQ                   ; X <-- P(T*T)/Q(T*T)
3553 46E3 20 F8 38              JSR   KLUGE19
3554 46E6 4C 3D 47              JMP   AGFINI
3555 46E9 20 5D 3C     KLUGE34  JSR   KLUGE42
3556 46EC A2 1C                 LDX   #F_FPK1
3557 46EE 20 A9 3A              JSR   KLUGE8
3558 46F1 20 FE 3E              JSR   KLUGE95
3559 46F4 60                    RTS   
3560 46F5              ;
3561 46F5              ; Long form.
3562 46F5              ;
3563 46F5 20 5D 3C     AGLONGFORM JSR   KLUGE42
3564 46F8 A2 52                 LDX   #F_FPKX2                 ; X2
3565 46FA 20 08 39              JSR   KLUGE24
3566 46FD A2 1C                 LDX   #F_FPK1                  ; Y <-- 1
3567 46FF 20 6D 3C              JSR   KLUGE52
3568 4702 A2 0C                 LDX   #F_W                     ; W = T*X2
3569 4704 A0 10                 LDY   #F_Y                     ; Y = 1
3570 4706 20 02 3F              JSR   KLUGE93
3571 4709 A2 1C                 LDX   #F_FPK1                  ; 1
3572 470B A0 10                 LDY   #F_Y                     ; Y = 1/(T*X2)
3573 470D 20 1C 39              JSR   KLUGE98
3574 4710 A2 1C                 LDX   #F_FPK1                  ; 1
3575 4712 A0 0C                 LDY   #F_W                     ; W = T*X2
3576 4714 20 1C 39              JSR   KLUGE98
3577 4717 A2 52                 LDX   #F_FPKX2                 ; Constant x2
3578 4719 20 71 3D              JSR   KLUGE90
3579 471C A2 00                 LDX   #F_DEST                  ; Z <-- T-x2
3580 471E 20 8C 45              JSR   KLUGE48
3581 4721 20 FE 3E              JSR   KLUGE95                  ; = B
3582 4724 A2 10                 LDX   #F_Y                     ; Y = 1 + 1/(T*x2)
3583 4726 A0 12                 LDY   #F_Z                     ; Z = T-x2
3584 4728 20 02 3F              JSR   KLUGE93                  ; = A
3585 472B A9 4E                 LDA   #F_ATANQ
3586 472D 20 91 45              JSR   POVERQ                   ; X <-- P(B*B)/Q(B*B)
3587 4730              ;                                       ; W <-- B*B, unused
3588 4730              ;                                       ; Y <-- junk
3589 4730              ;                                       ; Z   = A, still
3590 4730              ;                                       ; Res = B, still
3591 4730 20 F8 38              JSR   KLUGE19
3592 4733 A2 54                 LDX   #F_FPKX2FX2              ; Constant x2fx2
3593 4735 20 1A 39              JSR   KLUGE97
3594 4738 A2 12                 LDX   #F_Z                     ; Z = A
3595 473A 20 1A 39              JSR   KLUGE97
3596 473D              ;
3597 473D              ; Finish up by computing:
3598 473D              ;       no inversion above:  T - Result  in Result
3599 473D              ;       inversion above:     pi/2 - (T - Result)  in Result
3600 473D              ; Remember that T was saved in SRC eariler.
3601 473D              ;
3602 473D A2 02        AGFINI   LDX   #F_SRC                   ; Saved T
3603 473F 20 71 3D              JSR   KLUGE90
3604 4742 A5 F4                 LDA   <D2_TEMP                 ; Nonzero if inverted
3605 4744 D0 03                 BNE   AGSUBPI2
3606 4746 4C CC 3E              JMP   KLUGE62
3607 4749 A2 32        AGSUBPI2 LDX   #F_FPKPI2                ; PI/2
3608 474B 4C 1A 39              JMP   KLUGE97
3609 474E              ;
3610 474E              ; Random number generator.  Adapted from "A More Portable FORTRAN Random
3611 474E              ; Number Generator," Linus Schrage, ACM Transactions on Mathematical
3612 474E              ; Software, Vol. 5, No. 2, June 1979, pp. 132-138.
3613 474E              ;
3614 474E              ; NextT  <--  ARand * T + PRand
3615 474E              ;      where  ARand = 7^5  and  PRand = 2^31-1
3616 474E              ; X is presumed to be an integer strictly between 0 and 2^31-1.
3617 474E              ; Input:  DEST  = T
3618 474E              ; Ouput:  DEST  = NextT
3619 474E              ;
3620 474E                       EXPORT RANDTOP 
3621 474E              RANDTOP                                 ;       
3622 474E A2 58                 LDX   #F_FPKARAND
3623 4750 20 FA 38              JSR   KLUGE20
3624 4753 A2 5A                 LDX   #F_FPKPRAND
3625 4755 20 12 39              JSR   KLUGE99
3626 4758 20 C5 3E              JSR   KLUGE61
3627 475B 10 05                 BPL   z7s01                    ; done if result positive
3628 475D A2 5A                 LDX   #F_FPKPRAND              ;   else add 2^31-1
3629 475F 20 1A 39              JSR   KLUGE97
3630 4762 4C 9C 3B     Z7S01    JMP   RESULTDELIVERED
3631 4765                       LONGA ON
3632 4765                       LONGI ON
3633 4765                       ENDP 
3634 4765              ;
3635 4765              ; END OF FILE
3636 4765              ;
3637 4765              ;
3638 4765              ; END OF FILE
3639 4765              ;
3640 4765              ;
3641 4765
3642 4765
3643 4765                       END   
3644 4765
